/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.support;

import com.gitee.fastmybatis.core.FastmybatisContext;
import com.gitee.fastmybatis.core.PageInfo;
import com.gitee.fastmybatis.core.ext.MapperRunner;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.mapper.CrudMapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.support.PageEasyui;
import com.gitee.fastmybatis.core.support.TreeNode;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CommonService<E, I, Mapper extends CrudMapper<E, I>> {
    default public Mapper getMapper() {
        return (Mapper)((CrudMapper)this.getMapperRunner().getMapper());
    }

    default public MapperRunner<Mapper> getMapperRunner() {
        Class<?> entityClass = ClassUtil.getSuperInterfaceGenericType(this.getClass(), 0);
        return FastmybatisContext.getCrudMapperRunner(entityClass);
    }

    default public int saveOrUpdate(E entity) {
        return this.getMapperRunner().run(mapper -> mapper.saveOrUpdate(entity));
    }

    default public int saveOrUpdateIgnoreNull(E entity) {
        return this.getMapperRunner().run(mapper -> mapper.saveOrUpdateIgnoreNull(entity));
    }

    default public int delete(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.delete(entity));
    }

    default public int deleteById(I id) {
        Objects.requireNonNull(id);
        return this.getMapperRunner().run(mapper -> mapper.deleteById(id));
    }

    default public int deleteByIds(Collection<I> ids) {
        return this.getMapperRunner().run(mapper -> mapper.deleteByIds(ids));
    }

    default public int deleteByColumn(String column, Object value) {
        return this.getMapperRunner().run(mapper -> mapper.deleteByColumn(column, value));
    }

    default public int deleteByQuery(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.deleteByQuery(query));
    }

    default public int forceDelete(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.forceDelete(entity));
    }

    default public int forceDeleteById(I id) {
        Objects.requireNonNull(id);
        return this.getMapperRunner().run(mapper -> mapper.forceDeleteById(id));
    }

    default public int forceDeleteByQuery(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.forceDeleteByQuery(query));
    }

    default public int save(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.save(entity));
    }

    default public int saveIgnoreNull(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.saveIgnoreNull(entity));
    }

    default public int saveBatch(Collection<E> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new IllegalArgumentException("parameter 'entitys' can not empty");
        }
        return this.getMapperRunner().run(mapper -> mapper.saveBatch(entitys));
    }

    default public int saveMultiSet(Collection<E> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new IllegalArgumentException("parameter 'entitys' can not empty");
        }
        return this.getMapperRunner().run(mapper -> mapper.saveMultiSet(entitys));
    }

    default public int saveUnique(Collection<E> entitys) {
        return this.getMapperRunner().run(mapper -> mapper.saveUnique(entitys));
    }

    default public int saveUnique(Collection<E> entitys, Comparator<E> comparator) {
        Objects.requireNonNull(comparator);
        return this.getMapperRunner().run(mapper -> mapper.saveUnique(entitys, comparator));
    }

    default public E getById(I id) {
        Objects.requireNonNull(id);
        return (E)this.getMapperRunner().run(mapper -> mapper.getById(id));
    }

    default public E forceById(I id) {
        Objects.requireNonNull(id);
        return (E)this.getMapperRunner().run(mapper -> mapper.forceById(id));
    }

    default public E getByQuery(Query query) {
        return (E)this.getMapperRunner().run(mapper -> mapper.getByQuery(query));
    }

    default public E getBySpecifiedColumns(List<String> columns, Query query) {
        return (E)this.getMapperRunner().run(mapper -> mapper.getBySpecifiedColumns(columns, query));
    }

    default public <T> T getBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        return (T)this.getMapperRunner().run(mapper -> mapper.getBySpecifiedColumns(columns, query, clazz));
    }

    default public <T> T getColumnValue(String column, Query query, Class<T> clazz) {
        return (T)this.getMapperRunner().run(mapper -> mapper.getColumnValue(column, query, clazz));
    }

    default public E getByColumn(String column, Object value) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        Objects.requireNonNull(value, "parameter 'value' can not null");
        return (E)this.getMapperRunner().run(mapper -> mapper.getByColumn(column, value));
    }

    default public long getCount(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.getCount(query));
    }

    default public List<E> listByColumn(String column, Object value) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        Objects.requireNonNull(value, "parameter 'value' can not null");
        return this.getMapperRunner().run(mapper -> mapper.listByColumn(column, value));
    }

    default public List<E> list(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.list(query));
    }

    default public List<E> listByIds(Collection<I> ids) {
        return this.getMapperRunner().run(mapper -> mapper.listByIds(ids));
    }

    default public List<E> listByArray(String column, Object[] values) {
        return this.getMapperRunner().run(mapper -> mapper.listByArray(column, values));
    }

    default public List<E> listByCollection(String column, Collection<?> values) {
        return this.getMapperRunner().run(mapper -> mapper.listByCollection(column, values));
    }

    default public List<E> listBySpecifiedColumns(List<String> columns, Query query) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("parameter 'columns' can not empty");
        }
        return this.getMapperRunner().run(mapper -> mapper.listBySpecifiedColumns(columns, query));
    }

    default public <T> List<T> listBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        return this.getMapperRunner().run(mapper -> mapper.listBySpecifiedColumns(columns, query, clazz));
    }

    default public <T> List<T> listColumnValues(String column, Query query, Class<T> clazz) {
        return this.getMapperRunner().run(mapper -> mapper.listColumnValues(column, query, clazz));
    }

    default public <T> PageInfo<T> pageBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        return this.getMapperRunner().run(mapper -> mapper.pageBySpecifiedColumns(columns, query, clazz));
    }

    default public PageInfo<E> page(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.page(query));
    }

    default public <T> PageInfo<T> page(Query query, Supplier<T> target) {
        return this.getMapperRunner().run(mapper -> mapper.page(query, target));
    }

    default public <R> PageInfo<R> page(Query query, Function<E, R> converter) {
        return this.getMapperRunner().run(mapper -> mapper.page(query, converter));
    }

    default public <R> PageInfo<R> pageAndConvert(Query query, Function<List<E>, List<R>> converter) {
        return this.getMapperRunner().run(mapper -> mapper.pageAndConvert(query, converter));
    }

    default public <R> PageInfo<R> page(Query query, Supplier<R> target, Consumer<R> format) {
        return this.getMapperRunner().run(mapper -> mapper.page(query, target, format));
    }

    default public PageEasyui<E> pageEasyui(Query query) {
        return this.getMapperRunner().run(mapper -> mapper.pageEasyui(query));
    }

    default public <T> PageEasyui<T> pageEasyui(Query query, Class<T> clazz) {
        return this.getMapperRunner().run(mapper -> mapper.pageEasyui(query, clazz));
    }

    default public int update(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.update(entity));
    }

    default public int updateIgnoreNull(E entity) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.updateIgnoreNull(entity));
    }

    default public int updateByQuery(E entity, Query query, String ... ignoreProperties) {
        Objects.requireNonNull(entity);
        return this.getMapperRunner().run(mapper -> mapper.updateByQuery(entity, query, ignoreProperties));
    }

    default public int updateByMap(Map<String, Object> setBlock, Query query) {
        if (setBlock == null || setBlock.isEmpty()) {
            throw new IllegalArgumentException("parameter 'setBlock' can not empty");
        }
        return this.getMapperRunner().run(mapper -> mapper.updateByMap(setBlock, query));
    }

    default public <K> Map<K, E> getMap(Query query, Function<E, K> keyGetter) {
        return this.getMap(query, keyGetter, Function.identity());
    }

    default public <K, V> Map<K, V> getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter) {
        return this.getMap(query, keyGetter, valueGetter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        });
    }

    default public <K, V> Map<K, V> getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter, BinaryOperator<V> mergeFunction) {
        return this.getMap(query, keyGetter, valueGetter, mergeFunction, HashMap::new);
    }

    default public <K, V, M extends Map<K, V>> M getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return (M)this.getMapperRunner().run(mapper -> mapper.getMap(query, keyGetter, valueGetter, mergeFunction, mapSupplier));
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId) {
        return this.listTreeData(query, rootId, (E e) -> (TreeNode)e);
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId, Supplier<T> supplier) {
        return this.listTreeData(query, rootId, (E e) -> {
            TreeNode t = (TreeNode)supplier.get();
            SpiContext.getBeanExecutor().copyProperties(e, t);
            return t;
        });
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId, Function<E, T> converter) {
        return this.getMapperRunner().run(mapper -> mapper.listTreeData(query, rootId, converter));
    }
}

