/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.param;

import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.TenantQuery;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.param.PageParam;
import com.gitee.fastmybatis.core.query.param.SchPageableParam;
import com.gitee.fastmybatis.core.query.param.SchSortableParam;
import com.gitee.fastmybatis.core.util.StringUtil;

public class PageSortParam
extends PageParam
implements SchPageableParam,
SchSortableParam {
    @Condition(ignore=true)
    private String sort;
    @Condition(ignore=true)
    private String order;

    @Override
    public Query toQuery() {
        Query query = super.toQuery();
        if (StringUtil.hasText(this.fetchDBSortname()) && StringUtil.hasText(this.fetchSortorder())) {
            return query.addSort(this.fetchDBSortname(), this.fetchSortorder());
        }
        return query;
    }

    @Override
    public TenantQuery toTenantQuery() {
        TenantQuery tenantQuery = super.toTenantQuery();
        if (StringUtil.hasText(this.fetchDBSortname()) && StringUtil.hasText(this.fetchSortorder())) {
            tenantQuery.addSort(this.fetchDBSortname(), this.fetchSortorder());
        }
        return tenantQuery;
    }

    @Override
    public String fetchSortname() {
        return this.getSort();
    }

    @Override
    public String fetchSortorder() {
        return this.getOrder();
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

