/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.param;

import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.TenantQuery;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.param.PageParam;
import com.gitee.fastmybatis.core.query.param.SchPageableParam;
import com.gitee.fastmybatis.core.query.param.SortInfo;
import java.util.List;

public class PageMultiSortParam
extends PageParam
implements SchPageableParam {
    @Condition(ignore=true)
    private List<SortInfo> sorts;
    @Condition(ignore=true)
    private String sortInfo;

    @Override
    public Query toQuery() {
        Query query = super.toQuery();
        this.addSort(query);
        return query;
    }

    @Override
    public TenantQuery toTenantQuery() {
        TenantQuery tenantQuery = super.toTenantQuery();
        this.addSort(tenantQuery);
        return tenantQuery;
    }

    private void addSort(Query query) {
        block3: {
            block2: {
                String[] split;
                if (this.sortInfo == null || this.sortInfo.length() <= 0) break block2;
                for (String item : split = this.sortInfo.split(",")) {
                    String[] pair = item.split("=");
                    query.addSort(this.formatSortname(pair[0]), pair[1]);
                }
                break block3;
            }
            if (this.sorts == null) break block3;
            for (SortInfo sort : this.sorts) {
                query.addSort(this.formatSortname(sort.getSortname()), sort.getSortorder());
            }
        }
    }

    protected String formatSortname(String sortname) {
        return FieldUtil.camelToUnderline(sortname);
    }

    public List<SortInfo> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<SortInfo> sorts) {
        this.sorts = sorts;
    }

    public String getSortInfo() {
        return this.sortInfo;
    }

    public void setSortInfo(String sortInfo) {
        this.sortInfo = sortInfo;
    }
}

