/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.expression;

import com.gitee.fastmybatis.core.query.Joint;
import com.gitee.fastmybatis.core.query.expression.BetweenValue;
import com.gitee.fastmybatis.core.query.expression.ExpressionBetweenable;
import com.gitee.fastmybatis.core.query.expression.ExpressionType;
import java.util.List;
import java.util.Objects;

public class BetweenExpression
implements ExpressionBetweenable {
    private int index = Integer.MAX_VALUE;
    private String joint = "AND";
    private final String column;
    private final Object startValue;
    private final Object endValue;

    public BetweenExpression(String column, Object values) {
        this(Joint.AND, column, values);
    }

    public BetweenExpression(Joint joint, String column, Object values) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(column);
        this.joint = joint.getJoint();
        this.column = column;
        if (values.getClass().isArray()) {
            Object[] arr = (Object[])values;
            if (arr.length != 2) {
                throw new IllegalArgumentException("\u8bbe\u7f6e between \u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u6570\u7ec4\u5143\u7d20\u5fc5\u987b\u4e3a2\u4e2a\uff0c\u5f53\u524d\u4e2a\u6570\uff1a" + arr.length + "\u3002array[0]\u8868\u793a\u5f00\u59cb\u503c\uff0carray[1]\u8868\u793a\u7ed3\u675f\u503c");
            }
            this.startValue = arr[0];
            this.endValue = arr[1];
        } else if (values instanceof List) {
            List list = (List)values;
            if (list.size() != 2) {
                throw new IllegalArgumentException("\u8bbe\u7f6e between \u8868\u8fbe\u5f0f\u9519\u8bef\uff0clist\u5143\u7d20\u5fc5\u987b\u4e3a2\u4e2a\uff0c\u5f53\u524d\u4e2a\u6570\uff1a" + list.size() + "\u3002list.get(0)\u8868\u793a\u5f00\u59cb\u503c\uff0clist.get(1)\u8868\u793a\u7ed3\u675f\u503c");
            }
            this.startValue = list.get(0);
            this.endValue = list.get(1);
        } else if (values instanceof BetweenValue) {
            BetweenValue betweenValue = (BetweenValue)values;
            this.startValue = betweenValue.getStartValue();
            this.endValue = betweenValue.getEndValue();
        } else {
            throw new IllegalArgumentException("error between type");
        }
    }

    public BetweenExpression(String column, BetweenValue betweenValue) {
        Objects.requireNonNull(betweenValue);
        this.column = Objects.requireNonNull(column);
        this.startValue = Objects.requireNonNull(betweenValue.getStartValue());
        this.endValue = Objects.requireNonNull(betweenValue.getEndValue());
    }

    public BetweenExpression(String column, Object startValue, Object endValue) {
        this(Joint.AND, column, startValue, endValue);
    }

    public BetweenExpression(Joint joint, String column, Object startValue, Object endValue) {
        this.joint = joint.getJoint();
        this.column = Objects.requireNonNull(column);
        this.startValue = Objects.requireNonNull(startValue);
        this.endValue = Objects.requireNonNull(endValue);
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public Object getStartValue() {
        return this.startValue;
    }

    @Override
    public Object getEndValue() {
        return this.endValue;
    }

    @Override
    public ExpressionType expressionType() {
        return ExpressionType.BETWEEN;
    }

    public String getJoint() {
        return this.joint;
    }
}

