/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query;

import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.TenantQueryListener;
import com.gitee.fastmybatis.core.query.expression.ExpressionValueable;
import com.gitee.fastmybatis.core.query.param.IParam;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TenantQuery
extends Query {
    private static TenantQueryListener DEFAULT_TENANT_QUERY_LISTENER = query -> {};
    private static String DEFAULT_TENANT_COLUMN_NAME = "tenant_id";
    private final String tenantColumnName;

    public TenantQuery() {
        this(DEFAULT_TENANT_QUERY_LISTENER, DEFAULT_TENANT_COLUMN_NAME);
    }

    public TenantQuery(TenantQueryListener queryInterceptor, String tenantColumnName) {
        this.tenantColumnName = tenantColumnName;
        if (queryInterceptor != null) {
            queryInterceptor.onInitQuery(this);
        }
    }

    public TenantQuery(String tenantColumnName) {
        this(DEFAULT_TENANT_QUERY_LISTENER, tenantColumnName);
    }

    public static TenantQuery build(Object param) {
        if (param instanceof IParam) {
            return ((IParam)param).toTenantQuery();
        }
        return TenantQuery.buildFromBean(param);
    }

    private static TenantQuery buildFromBean(Object bean) {
        TenantQuery query = new TenantQuery();
        TenantQuery.bindExpressionsFromBean(bean, query);
        return query;
    }

    public Object getTenantValue() {
        List<ExpressionValueable> valueExpressions = this.getValueExpressions();
        if (valueExpressions == null || valueExpressions.isEmpty()) {
            return null;
        }
        return valueExpressions.stream().filter(expressionValueable -> Objects.equals(this.getTenantColumnName(), expressionValueable.getColumn())).findFirst().map(ExpressionValueable::getValue).orElse(null);
    }

    public <T> List<ExpressionValueable> getValueExpressions() {
        return this.getExpressions().stream().filter(expression -> expression instanceof ExpressionValueable).map(expression -> (ExpressionValueable)expression).collect(Collectors.toList());
    }

    public static void setDefaultTenantQueryListener(TenantQueryListener defaultTenantQueryListener) {
        DEFAULT_TENANT_QUERY_LISTENER = defaultTenantQueryListener;
    }

    public static void setDefaultTenantColumnName(String defaultTenantColumnName) {
        DEFAULT_TENANT_COLUMN_NAME = defaultTenantColumnName;
    }

    public String getTenantColumnName() {
        return this.tenantColumnName;
    }

    public boolean existTenantValue() {
        return this.getTenantValue() != null;
    }
}

