/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query;

import com.gitee.fastmybatis.core.query.Condition;
import com.gitee.fastmybatis.core.query.ConditionAnd;
import com.gitee.fastmybatis.core.query.ConditionChain;
import com.gitee.fastmybatis.core.query.ConditionOr;
import com.gitee.fastmybatis.core.query.ExpressionSortUtil;
import com.gitee.fastmybatis.core.query.Joint;
import com.gitee.fastmybatis.core.query.Queryable;
import com.gitee.fastmybatis.core.query.Sort;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.ExpressionJoinable;
import com.gitee.fastmybatis.core.query.expression.Expressional;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.builder.ConditionBuilder;
import com.gitee.fastmybatis.core.query.param.IParam;
import com.gitee.fastmybatis.core.query.param.SchSortableParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Query
implements Queryable,
ConditionAnd<Query>,
ConditionOr<Query> {
    private int start;
    private int limit;
    private int total = -1;
    private LinkedHashSet<String> orderInfo;
    private Map<String, Object> paramMap;
    private boolean forceQuery;
    private boolean distinct;
    private boolean forceUpdate;
    private List<ExpressionJoinable> joinExpressions;
    private final Condition condition = new Condition();

    public Query join(String joinSql) {
        if (this.joinExpressions == null) {
            this.joinExpressions = new ArrayList<ExpressionJoinable>(2);
        }
        this.joinExpressions.add((ExpressionJoinable)Expressions.join(joinSql));
        return this;
    }

    public Query and(ConditionChain conditionChain) {
        this.condition.subCondition(Joint.AND, conditionChain.apply(new Condition()));
        return this;
    }

    public Query or(ConditionChain conditionChain) {
        this.condition.subCondition(Joint.OR, conditionChain.apply(new Condition()));
        return this;
    }

    public List<Expression> getExpressions() {
        return this.condition.getExpressions();
    }

    public Query page(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            throw new IllegalArgumentException("pageIndex\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        int start = (pageIndex - 1) * pageSize;
        return this.limit(start, pageSize);
    }

    public Query limit(int start, int offset) {
        if (offset == 0) {
            this.setQueryAll(true);
            return this;
        }
        if (start < 0) {
            throw new IllegalArgumentException("public Query limit(int start, int offset)\u65b9\u6cd5start\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (offset < 1) {
            throw new IllegalArgumentException("public Query limit(int start, int offset)\u65b9\u6cd5offset\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        this.start = start;
        this.limit = offset;
        return this;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public boolean getIsSetTotal() {
        return this.total != -1;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public Query orderby(String sortname, Sort sort) {
        return this.addSort(sortname, sort);
    }

    public Query addSort(String sortname) {
        return this.addSort(sortname, "ASC");
    }

    public Query addSort(String sortname, Sort sort) {
        return this.addSort(sortname, sort.name());
    }

    public Query addSort(String sortname, String sortorder) {
        if (!"DESC".equalsIgnoreCase(sortorder) && !"ASC".equalsIgnoreCase(sortorder)) {
            throw new IllegalArgumentException("error order:" + sortorder);
        }
        if (sortname != null && sortname.length() > 0) {
            if (this.orderInfo == null) {
                this.orderInfo = new LinkedHashSet();
            }
            sortname = sortname.replaceAll(this.condition.getSqlInjectRegex(), "");
            if (!"DESC".equalsIgnoreCase(sortorder)) {
                sortorder = "ASC";
            }
            this.orderInfo.add(sortname + " " + sortorder);
        }
        return this;
    }

    @Override
    public boolean getOrderable() {
        return this.orderInfo != null;
    }

    @Override
    public String getOrder() {
        if (this.orderInfo == null) {
            throw new NullPointerException("orderInfo\u4e3a\u7a7a,\u5fc5\u987b\u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5.");
        }
        StringBuilder sb = new StringBuilder();
        for (String order : this.orderInfo) {
            sb.append(",").append(order);
        }
        if (sb.length() > 0) {
            return sb.toString().substring(1);
        }
        return "";
    }

    public Query addAnnotionExpression(Object searchEntity) {
        Query.bindExpressionsFromBean(searchEntity, this);
        return this;
    }

    public Query addSortInfo(SchSortableParam searchEntity) {
        this.addSort(searchEntity.fetchDBSortname(), searchEntity.fetchSortorder());
        return this;
    }

    public static Query build(Object searchEntity) {
        if (searchEntity instanceof IParam) {
            return ((IParam)searchEntity).toQuery();
        }
        return Query.buildFromBean(searchEntity);
    }

    private static Query buildFromBean(Object bean) {
        Query query = new Query();
        Query.bindExpressionsFromBean(bean, query);
        return query;
    }

    protected static void bindExpressionsFromBean(Object bean, Query query) {
        List<Expression> expressions = ConditionBuilder.getUnderlineFieldBuilder().buildExpressions(bean);
        for (Expression expression : expressions) {
            query.addExpression(expression);
        }
    }

    public static Query buildFromBeanByProperty(Object bean) {
        Query query = new Query();
        List<Expression> expressions = ConditionBuilder.getCamelFieldBuilder().buildExpressions(bean);
        for (Expression expression : expressions) {
            query.addExpression(expression);
        }
        return query;
    }

    @Override
    public Expressional addExpression(Expression expression) {
        if (expression instanceof ExpressionJoinable) {
            if (this.joinExpressions == null) {
                this.joinExpressions = new ArrayList<ExpressionJoinable>(2);
            }
            this.joinExpressions.add((ExpressionJoinable)expression);
        } else {
            this.condition.addExpression(expression);
        }
        return this;
    }

    public void addAll(List<Expression> expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                this.addExpression(expression);
            }
        }
    }

    public Query addParam(String name, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, Object>(16);
        }
        this.paramMap.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getParam() {
        return this.paramMap;
    }

    @Override
    public boolean getIsQueryAll() {
        return this.limit == 0;
    }

    public Query setQueryAll(boolean queryAll) {
        if (queryAll) {
            this.limit = 0;
        }
        return this;
    }

    @Override
    public List<ExpressionJoinable> getJoinExpressions() {
        return ExpressionSortUtil.sort(this.joinExpressions);
    }

    public boolean getForceQuery() {
        return this.forceQuery;
    }

    public Query enableForceQuery() {
        this.forceQuery = true;
        return this;
    }

    public Query ignoreLogicDeleteColumn() {
        this.forceQuery = true;
        return this;
    }

    public Query disableForceQuery() {
        this.forceQuery = false;
        return this;
    }

    public Query enableDistinct() {
        this.distinct = true;
        return this;
    }

    public Query disableDistinct() {
        this.distinct = false;
        return this;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public Query enableForceUpdate() {
        this.forceUpdate = true;
        return this;
    }

    public Query disableForceUpdate() {
        this.forceUpdate = false;
        return this;
    }

    public boolean getForceUpdate() {
        return this.forceUpdate;
    }

    public Query argPlaceholder(String argPlaceholder) {
        this.condition.setArgPlaceholder(argPlaceholder);
        return this;
    }

    public Query sqlInjectRegex(String sqlInjectRegex) {
        this.condition.setSqlInjectRegex(sqlInjectRegex);
        return this;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

