/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query;

import com.gitee.fastmybatis.core.query.ExpressionSortUtil;
import com.gitee.fastmybatis.core.query.Joint;
import com.gitee.fastmybatis.core.query.Operator;
import com.gitee.fastmybatis.core.query.expression.BetweenValue;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.ExpressionJoinable;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.SubExpression;
import com.gitee.fastmybatis.core.query.expression.ValueConvert;
import com.gitee.fastmybatis.core.query.expression.ValueExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class Condition {
    private static final String DEFAULT_SQL_INJECT_REGEX = "([';])+|(--)+";
    private static final String DEFAULT_ARG_PLACEHOLDER = "?";
    private String argPlaceholder = "?";
    private String sqlInjectRegex = "([';])+|(--)+";
    protected final List<Expression> expressions = new ArrayList<Expression>(4);

    public void setArgPlaceholder(String argPlaceholder) {
        this.argPlaceholder = argPlaceholder;
    }

    public void setSqlInjectRegex(String sqlInjectRegex) {
        this.sqlInjectRegex = sqlInjectRegex;
    }

    public String getArgPlaceholder() {
        return this.argPlaceholder;
    }

    public String getSqlInjectRegex() {
        return this.sqlInjectRegex;
    }

    public Condition eq(String columnName, Object value) {
        this.addExpression(Expressions.eq(columnName, value));
        return this;
    }

    public Condition eq(boolean expression, String columnName, Object value) {
        if (expression) {
            this.eq(columnName, value);
        }
        return this;
    }

    public Condition notEq(String columnName, Object value) {
        this.addExpression(Expressions.notEq(columnName, value));
        return this;
    }

    public Condition notEq(boolean expression, String columnName, Object value) {
        if (expression) {
            this.notEq(columnName, value);
        }
        return this;
    }

    public Condition gt(String columnName, Object value) {
        this.addExpression(Expressions.gt(columnName, value));
        return this;
    }

    public Condition gt(boolean expression, String columnName, Object value) {
        if (expression) {
            this.gt(columnName, value);
        }
        return this;
    }

    public Condition ge(String columnName, Object value) {
        this.addExpression(Expressions.ge(columnName, value));
        return this;
    }

    public Condition ge(boolean expression, String columnName, Object value) {
        if (expression) {
            this.ge(columnName, value);
        }
        return this;
    }

    public Condition lt(String columnName, Object value) {
        this.addExpression(Expressions.lt(columnName, value));
        return this;
    }

    public Condition lt(boolean expression, String columnName, Object value) {
        if (expression) {
            this.lt(columnName, value);
        }
        return this;
    }

    public Condition le(String columnName, Object value) {
        this.addExpression(Expressions.le(columnName, value));
        return this;
    }

    public Condition le(boolean expression, String columnName, Object value) {
        if (expression) {
            this.le(columnName, value);
        }
        return this;
    }

    public Condition like(String columnName, String value) {
        this.addExpression(Expressions.like(columnName, value));
        return this;
    }

    public Condition like(boolean expression, String columnName, String value) {
        if (expression) {
            this.like(columnName, value);
        }
        return this;
    }

    public Condition likeLeft(String columnName, String value) {
        this.addExpression(Expressions.likeLeft(columnName, value));
        return this;
    }

    public Condition likeLeft(boolean expression, String columnName, String value) {
        if (expression) {
            this.likeLeft(columnName, value);
        }
        return this;
    }

    public Condition likeRight(String columnName, String value) {
        this.addExpression(Expressions.likeRight(columnName, value));
        return this;
    }

    public Condition likeRight(boolean expression, String columnName, String value) {
        if (expression) {
            this.likeRight(columnName, value);
        }
        return this;
    }

    public Condition in(String columnName, Collection<?> value) {
        this.addExpression(Expressions.in(columnName, value));
        return this;
    }

    public Condition in(boolean expression, String columnName, Collection<?> value) {
        if (expression) {
            this.in(columnName, value);
        }
        return this;
    }

    public <T> Condition in(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.in(columnName, value, valueConvert));
        return this;
    }

    public <T> Condition in(boolean expression, String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        if (expression) {
            this.in(columnName, value, valueConvert);
        }
        return this;
    }

    public Condition in(String columnName, Object[] value) {
        this.addExpression(Expressions.in(columnName, value));
        return this;
    }

    public Condition in(boolean expression, String columnName, Object[] value) {
        if (expression) {
            this.in(columnName, value);
        }
        return this;
    }

    public Condition notIn(String columnName, Collection<?> value) {
        this.addExpression(Expressions.notIn(columnName, value));
        return this;
    }

    public Condition notIn(boolean expression, String columnName, Collection<?> value) {
        if (expression) {
            this.notIn(columnName, value);
        }
        return this;
    }

    public <T> Condition notIn(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.notIn(columnName, value, valueConvert));
        return this;
    }

    public <T> Condition notIn(boolean expression, String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        if (expression) {
            this.notIn(columnName, value, valueConvert);
        }
        return this;
    }

    public Condition notIn(String columnName, Object[] value) {
        this.addExpression(Expressions.notIn(columnName, value));
        return this;
    }

    public Condition notIn(boolean expression, String columnName, Object[] value) {
        if (expression) {
            this.notIn(columnName, value);
        }
        return this;
    }

    private Condition doBetween(String columnName, Object value) {
        this.addExpression(Expressions.between(columnName, value));
        return this;
    }

    public Condition between(String columnName, Object startValue, Object endValue) {
        this.between(columnName, new BetweenValue(startValue, endValue));
        return this;
    }

    public Condition between(boolean expression, String columnName, Object startValue, Object endValue) {
        if (expression) {
            this.between(columnName, startValue, endValue);
        }
        return this;
    }

    public Condition between(String columnName, Object[] values) {
        this.doBetween(columnName, values);
        return this;
    }

    public Condition between(boolean expression, String columnName, Object[] values) {
        if (expression) {
            this.between(columnName, values);
        }
        return this;
    }

    public Condition between(String columnName, List<?> values) {
        this.doBetween(columnName, values);
        return this;
    }

    public Condition between(boolean expression, String columnName, List<?> values) {
        if (expression) {
            this.between(columnName, values);
        }
        return this;
    }

    public Condition between(String columnName, BetweenValue betweenValue) {
        this.doBetween(columnName, betweenValue);
        return this;
    }

    public Condition between(boolean expression, String columnName, BetweenValue betweenValue) {
        if (expression) {
            this.between(columnName, betweenValue);
        }
        return this;
    }

    public Condition sql(String sql) {
        this.addExpression(Expressions.sql(sql));
        return this;
    }

    public Condition sql(boolean expression, String sql) {
        if (expression) {
            this.sql(sql);
        }
        return this;
    }

    public Condition sql(String sqlFormat, Object ... args) {
        String sql = this.formatSql(sqlFormat, args);
        this.addExpression(Expressions.sql(sql));
        return this;
    }

    public Condition sql(boolean expression, String sqlFormat, Object ... args) {
        if (expression) {
            this.sql(sqlFormat, args);
        }
        return this;
    }

    public Condition notNull(String column) {
        return this.sql(column + " IS NOT NULL");
    }

    public Condition notNull(boolean expression, String column) {
        if (expression) {
            this.notNull(column);
        }
        return this;
    }

    public Condition isNull(String column) {
        return this.sql(column + " IS NULL");
    }

    public Condition isNull(boolean expression, String column) {
        if (expression) {
            this.isNull(column);
        }
        return this;
    }

    public Condition notEmpty(String column) {
        return this.sql(column + " IS NOT NULL AND " + column + " <> '' ");
    }

    public Condition notEmpty(boolean expression, String column) {
        if (expression) {
            this.notEmpty(column);
        }
        return this;
    }

    public Condition isEmpty(String column) {
        return this.sql(column + " IS NULL OR " + column + " = '' ");
    }

    public Condition isEmpty(boolean expression, String column) {
        if (expression) {
            this.isEmpty(column);
        }
        return this;
    }

    public Condition oneEqTwo() {
        return this.sql("1=2");
    }

    public Condition oneEqTwo(boolean expression) {
        if (expression) {
            this.oneEqTwo();
        }
        return this;
    }

    public Condition allEq(LinkedHashMap<String, Object> map) {
        Set<String> keys = map.keySet();
        for (String columnName : keys) {
            this.eq(columnName, map.get(columnName));
        }
        return this;
    }

    public Condition allEq(boolean expression, LinkedHashMap<String, Object> map) {
        if (expression) {
            this.allEq(map);
        }
        return this;
    }

    public Condition orEq(String columnName, Object value) {
        this.addExpression(new ValueExpression(Joint.OR.getJoint(), columnName, Operator.eq.getOperator(), value));
        return this;
    }

    public Condition orEq(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orEq(columnName, value);
        }
        return this;
    }

    public Condition orNotEq(String columnName, Object value) {
        this.addExpression(Expressions.orNotEq(columnName, value));
        return this;
    }

    public Condition orNotEq(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orNotEq(columnName, value);
        }
        return this;
    }

    public Condition orGt(String columnName, Object value) {
        this.addExpression(Expressions.orGt(columnName, value));
        return this;
    }

    public Condition orGt(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orGt(columnName, value);
        }
        return this;
    }

    public Condition orGe(String columnName, Object value) {
        this.addExpression(Expressions.orGe(columnName, value));
        return this;
    }

    public Condition orGe(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orGe(columnName, value);
        }
        return this;
    }

    public Condition orLt(String columnName, Object value) {
        this.addExpression(Expressions.orLt(columnName, value));
        return this;
    }

    public Condition orLt(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orLt(columnName, value);
        }
        return this;
    }

    public Condition orLe(String columnName, Object value) {
        this.addExpression(Expressions.orLe(columnName, value));
        return this;
    }

    public Condition orLe(boolean expression, String columnName, Object value) {
        if (expression) {
            this.orLe(columnName, value);
        }
        return this;
    }

    public Condition orLike(String columnName, String value) {
        this.addExpression(Expressions.orLike(columnName, value));
        return this;
    }

    public Condition orLike(boolean expression, String columnName, String value) {
        if (expression) {
            this.orLike(columnName, value);
        }
        return this;
    }

    public Condition orLikeLeft(String columnName, String value) {
        this.addExpression(Expressions.orLikeLeft(columnName, value));
        return this;
    }

    public Condition orLikeLeft(boolean expression, String columnName, String value) {
        if (expression) {
            this.orLikeLeft(columnName, value);
        }
        return this;
    }

    public Condition orLikeRight(String columnName, String value) {
        this.addExpression(Expressions.orLikeRight(columnName, value));
        return this;
    }

    public Condition orLikeRight(boolean expression, String columnName, String value) {
        if (expression) {
            this.orLikeRight(columnName, value);
        }
        return this;
    }

    public Condition orIn(String columnName, Collection<?> value) {
        this.addExpression(Expressions.orIn(columnName, value));
        return this;
    }

    public Condition orIn(boolean expression, String columnName, Collection<?> value) {
        if (expression) {
            this.orIn(columnName, value);
        }
        return this;
    }

    public <T> Condition orIn(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.orIn(columnName, value, valueConvert));
        return this;
    }

    public <T> Condition orIn(boolean expression, String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        if (expression) {
            this.orIn(columnName, value, valueConvert);
        }
        return this;
    }

    public Condition orIn(String columnName, Object[] value) {
        this.addExpression(Expressions.orIn(columnName, value));
        return this;
    }

    public Condition orIn(boolean expression, String columnName, Object[] value) {
        if (expression) {
            this.orIn(columnName, value);
        }
        return this;
    }

    public Condition orNotIn(String columnName, Collection<?> value) {
        this.addExpression(Expressions.orNotIn(columnName, value));
        return this;
    }

    public Condition orNotIn(boolean expression, String columnName, Collection<?> value) {
        if (expression) {
            this.orNotIn(columnName, value);
        }
        return this;
    }

    public <T> Condition orNotIn(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.orNotIn(columnName, value, valueConvert));
        return this;
    }

    public <T> Condition orNotIn(boolean expression, String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        if (expression) {
            this.orNotIn(columnName, value, valueConvert);
        }
        return this;
    }

    public Condition orNotIn(String columnName, Object[] value) {
        this.addExpression(Expressions.orNotIn(columnName, value));
        return this;
    }

    public Condition orNotIn(boolean expression, String columnName, Object[] value) {
        if (expression) {
            this.orNotIn(columnName, value);
        }
        return this;
    }

    private Condition doOrBetween(String columnName, Object value) {
        this.addExpression(Expressions.orBetween(columnName, value));
        return this;
    }

    public Condition orBetween(String columnName, Object startValue, Object endValue) {
        this.orBetween(columnName, new BetweenValue(startValue, endValue));
        return this;
    }

    public Condition orBetween(boolean expression, String columnName, Object startValue, Object endValue) {
        if (expression) {
            this.orBetween(columnName, startValue, endValue);
        }
        return this;
    }

    public Condition orBetween(String columnName, Object[] values) {
        this.doOrBetween(columnName, values);
        return this;
    }

    public Condition orBetween(boolean expression, String columnName, Object[] values) {
        if (expression) {
            this.orBetween(columnName, values);
        }
        return this;
    }

    public Condition orBetween(String columnName, List<?> values) {
        this.doOrBetween(columnName, values);
        return this;
    }

    public Condition orBetween(boolean expression, String columnName, List<?> values) {
        if (expression) {
            this.orBetween(columnName, values);
        }
        return this;
    }

    public Condition orBetween(String columnName, BetweenValue betweenValue) {
        this.doOrBetween(columnName, betweenValue);
        return this;
    }

    public Condition orBetween(boolean expression, String columnName, BetweenValue betweenValue) {
        if (expression) {
            this.orBetween(columnName, betweenValue);
        }
        return this;
    }

    public Condition orSql(String orSql) {
        this.addExpression(Expressions.orSql(orSql));
        return this;
    }

    public Condition orSql(boolean expression, String orSql) {
        if (expression) {
            this.orSql(orSql);
        }
        return this;
    }

    public Condition orSql(String sqlFormat, Object ... args) {
        String sql = this.formatSql(sqlFormat, args);
        this.addExpression(Expressions.orSql(sql));
        return this;
    }

    private String formatSql(String sqlFormat, Object ... args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof CharSequence)) continue;
                args[i] = arg.toString().replaceAll(this.sqlInjectRegex, "");
            }
            for (Object arg : args) {
                sqlFormat = sqlFormat.replaceFirst(String.format("\\%s", this.argPlaceholder), String.valueOf(arg));
            }
        }
        return sqlFormat;
    }

    public Condition orSql(boolean expression, String sqlFormat, Object ... args) {
        if (expression) {
            this.orSql(sqlFormat, args);
        }
        return this;
    }

    public Condition orNotNull(String column) {
        return this.orSql(column + " IS NOT NULL");
    }

    public Condition orNotNull(boolean expression, String column) {
        if (expression) {
            this.orNotNull(column);
        }
        return this;
    }

    public Condition orIsNull(String column) {
        return this.orSql(column + " IS NULL");
    }

    public Condition orIsNull(boolean expression, String column) {
        if (expression) {
            this.orIsNull(column);
        }
        return this;
    }

    public Condition orNotEmpty(String column) {
        return this.orSql(column + " IS NOT NULL AND " + column + " <> '' ");
    }

    public Condition orNotEmpty(boolean expression, String column) {
        if (expression) {
            this.orNotEmpty(column);
        }
        return this;
    }

    public Condition orIsEmpty(String column) {
        return this.orSql(column + " IS NULL OR " + column + " = '' ");
    }

    public Condition orIsEmpty(boolean expression, String column) {
        if (expression) {
            this.orIsEmpty(column);
        }
        return this;
    }

    public Condition addExpression(Expression expression) {
        if (expression instanceof ExpressionJoinable) {
            throw new IllegalArgumentException("Where\u4e0d\u652f\u6301Join\u8868\u8fbe\u5f0f");
        }
        this.expressions.add(expression);
        return this;
    }

    public List<Expression> getExpressions() {
        return ExpressionSortUtil.sort(this.expressions);
    }

    protected Condition subCondition(Joint joint, Condition condition) {
        this.addExpression(new SubExpression(joint.getJoint(), condition));
        return this;
    }
}

