/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.mapper;

import com.gitee.fastmybatis.core.FastmybatisContext;
import com.gitee.fastmybatis.core.PageInfo;
import com.gitee.fastmybatis.core.ext.spi.BeanExecutor;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.mapper.Mapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.support.PageEasyui;
import com.gitee.fastmybatis.core.support.TreeNode;
import com.gitee.fastmybatis.core.util.ClassUtil;
import com.gitee.fastmybatis.core.util.MapperUtil;
import com.gitee.fastmybatis.core.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Param;

public interface SchMapper<E, I>
extends Mapper<E> {
    public static final String BASE_RESULT_MAP = "baseResultMap";

    public E getById(I var1);

    public E forceById(I var1);

    public E getByQuery(@Param(value="query") Query var1);

    default public E getBySpecifiedColumns(List<String> columns, Query query) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("parameter 'columns' can not empty");
        }
        query.limit(0, 1);
        List<E> list = this.listBySpecifiedColumns(columns, query);
        return list.isEmpty() ? null : (E)list.get(0);
    }

    default public <T> T getBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        Objects.requireNonNull(clazz, "parameter 'clazz' can not null");
        E e = this.getBySpecifiedColumns(columns, query);
        if (ClassUtil.isPrimitive(clazz.getSimpleName())) {
            return SpiContext.getBeanExecutor().pojoToValue(e, clazz, columns.get(0));
        }
        return SpiContext.getBeanExecutor().copyBean(e, clazz);
    }

    default public <T> T getColumnValue(String column, Query query, Class<T> clazz) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        Objects.requireNonNull(clazz, "parameter 'clazz' can not null");
        if (!ClassUtil.isPrimitive(clazz.getSimpleName())) {
            throw new IllegalArgumentException("parameter `clazz` must be a single value class, such as: Integer.class, String.class, Date.class");
        }
        return this.getBySpecifiedColumns(Collections.singletonList(column), query, clazz);
    }

    public E getByColumn(@Param(value="column") String var1, @Param(value="value") Object var2);

    public long getCount(@Param(value="query") Query var1);

    public List<E> listByColumn(@Param(value="column") String var1, @Param(value="value") Object var2);

    public List<E> list(@Param(value="query") Query var1);

    default public List<E> listByIds(Collection<I> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        Class<?> entityClass = ClassUtil.getSuperInterfaceGenericType(this.getClass(), 0);
        String pkColumnName = FastmybatisContext.getPkColumnName(entityClass);
        return this.listByCollection(pkColumnName, ids);
    }

    default public List<E> listByArray(String column, Object[] values) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        if (values == null || values.length == 0) {
            return new ArrayList();
        }
        return this.listByCollection(column, Arrays.asList(values));
    }

    default public List<E> listByCollection(String column, Collection<?> values) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        if (values == null || values.isEmpty()) {
            return new ArrayList();
        }
        Query query = (Query)new Query().in(column, values);
        return this.list(query);
    }

    public List<E> listBySpecifiedColumns(@Param(value="columns") List<String> var1, @Param(value="query") Query var2);

    default public <T> List<T> listBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("parameter 'columns' can not empty");
        }
        Objects.requireNonNull(query, "parameter 'query' can not null");
        Objects.requireNonNull(clazz, "parameter 'clazz' can not null");
        List<Map<String, Object>> mapList = this.listMap(columns, query);
        if (mapList == null) {
            return new ArrayList(0);
        }
        BeanExecutor beanExecutor = SpiContext.getBeanExecutor();
        if (ClassUtil.isPrimitive(clazz.getSimpleName())) {
            return mapList.stream().map(obj -> beanExecutor.pojoToValue(obj, clazz, (String)columns.get(0))).collect(Collectors.toList());
        }
        return beanExecutor.copyBean(mapList, clazz);
    }

    public List<Map<String, Object>> listMap(@Param(value="columns") List<String> var1, @Param(value="query") Query var2);

    default public <T> List<T> listColumnValues(String column, Query query, Class<T> clazz) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'column' can not blank");
        }
        Objects.requireNonNull(clazz, "parameter 'clazz' can not null");
        if (!ClassUtil.isPrimitive(clazz.getSimpleName())) {
            throw new IllegalArgumentException("param `clazz` must be a single value class, such as: Integer.class, String.class, Date.class");
        }
        return this.listBySpecifiedColumns(Collections.singletonList(column), query, clazz);
    }

    default public <T> PageInfo<T> pageBySpecifiedColumns(List<String> columns, Query query, Class<T> clazz) {
        return MapperUtil.query(columns, this, query, clazz);
    }

    default public PageInfo<E> page(Query query) {
        return MapperUtil.query(this, query);
    }

    default public <T> PageInfo<T> page(Query query, Class<T> clazz) {
        return MapperUtil.queryAndConvert(this, query, clazz);
    }

    default public <T> PageInfo<T> page(Query query, Supplier<T> target) {
        return MapperUtil.queryAndConvert(this, query, target);
    }

    default public <R> PageInfo<R> page(Query query, Function<E, R> converter) {
        PageInfo pageInfo = this.page(query);
        List<E> list = pageInfo.getList();
        List retList = list.stream().map(converter).collect(Collectors.toList());
        pageInfo.setList(retList);
        return pageInfo;
    }

    default public <R> PageInfo<R> pageAndConvert(Query query, Function<List<E>, List<R>> converter) {
        PageInfo<R> pageInfo = this.page(query);
        List<E> list = pageInfo.getList();
        List<R> retList = converter.apply(list);
        pageInfo.setList(retList);
        return pageInfo;
    }

    default public <R> PageInfo<R> page(Query query, Supplier<R> target, Consumer<R> format) {
        return this.page(query, (E t) -> {
            Object r = target.get();
            SpiContext.getBeanExecutor().copyProperties(t, r);
            format.accept(r);
            return r;
        });
    }

    default public PageEasyui<E> pageEasyui(Query query) {
        return MapperUtil.queryForEasyuiDatagrid(this, query);
    }

    default public <T> PageEasyui<T> pageEasyui(Query query, Class<T> clazz) {
        return MapperUtil.queryForEasyuiDatagrid(this, query, clazz);
    }

    default public <R> PageEasyui<R> pageEasyui(Query query, Function<E, R> converter) {
        PageEasyui pageInfo = this.pageEasyui(query);
        List<E> list = pageInfo.getRows();
        List retList = list.stream().map(converter).collect(Collectors.toList());
        pageInfo.setList(retList);
        return pageInfo;
    }

    default public <K> Map<K, E> getMap(Query query, Function<E, K> keyGetter) {
        return this.getMap(query, keyGetter, Function.identity());
    }

    default public <K, V> Map<K, V> getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter) {
        return this.getMap(query, keyGetter, valueGetter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        });
    }

    default public <K, V> Map<K, V> getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter, BinaryOperator<V> mergeFunction) {
        return this.getMap(query, keyGetter, valueGetter, mergeFunction, HashMap::new);
    }

    default public <K, V, M extends Map<K, V>> M getMap(Query query, Function<E, K> keyGetter, Function<E, V> valueGetter, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.list(query).stream().collect(Collectors.toMap(keyGetter, valueGetter, mergeFunction, mapSupplier)));
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId) {
        return this.listTreeData(query, rootId, (E e) -> (TreeNode)e);
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId, Supplier<T> supplier) {
        return this.listTreeData(query, rootId, (E e) -> {
            TreeNode t = (TreeNode)supplier.get();
            SpiContext.getBeanExecutor().copyProperties(e, t);
            return t;
        });
    }

    default public <T extends TreeNode<T, I>> List<T> listTreeData(Query query, I rootId, Function<E, T> converter) {
        List list = this.list(query).stream().map(converter).collect(Collectors.toList());
        return TreeUtil.convertTree(list, rootId);
    }

    default public boolean checkExistById(E entity) {
        Object pkValue = FastmybatisContext.getPkValue(entity);
        if (pkValue == null) {
            return false;
        }
        String pkColumnName = FastmybatisContext.getPkColumnName(entity.getClass());
        return this.checkExist(pkColumnName, pkValue);
    }

    default public boolean checkExist(String columnName, Object value) {
        Objects.requireNonNull(columnName, "columnName can not null");
        Objects.requireNonNull(value, "value can not null");
        Object columnValue = this.getColumnValue(columnName, (Query)new Query().eq(columnName, value), Object.class);
        return columnValue != null;
    }
}

