/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.mapper;

import com.gitee.fastmybatis.core.mapper.Mapper;
import com.gitee.fastmybatis.core.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface SaveMapper<E>
extends Mapper<E> {
    public int save(E var1);

    public int saveIgnoreNull(E var1);

    public int saveBatch(@Param(value="entitys") Collection<E> var1);

    default public int saveBatchIgnoreNull(Collection<E> records) {
        if (records == null || records.isEmpty()) {
            return 0;
        }
        List<String> notNullColumns = ListUtil.getNotNullFieldNames(records);
        return this.saveBatchBySpecifiedColumns(records, notNullColumns);
    }

    default public int saveBatchIgnoreNull(Collection<E> records, int partitionSize) {
        if (records == null || records.isEmpty()) {
            return 0;
        }
        if (partitionSize < 1) {
            throw new IllegalArgumentException("\u53c2\u6570 partitionSize \u5fc5\u987b\u5927\u4e8e 0");
        }
        int successCount = 0;
        List list = records instanceof List ? (List)records : new ArrayList<E>(records);
        List partition = ListUtil.partition(list, partitionSize);
        for (List subList : partition) {
            List<String> notNullColumns = ListUtil.getNotNullFieldNames(subList);
            int i = this.saveBatchBySpecifiedColumns(subList, notNullColumns);
            successCount += i;
        }
        return successCount;
    }

    public int saveBatchBySpecifiedColumns(@Param(value="entitys") Collection<E> var1, @Param(value="saveFieldNames") List<String> var2);

    default public int saveBatch(Collection<E> records, int partitionSize) {
        if (records == null || records.isEmpty()) {
            return 0;
        }
        if (partitionSize < 1) {
            throw new IllegalArgumentException("\u53c2\u6570 partitionSize \u5fc5\u987b\u5927\u4e8e 0");
        }
        int successCount = 0;
        List list = records instanceof List ? (List)records : new ArrayList<E>(records);
        List partition = ListUtil.partition(list, partitionSize);
        for (List subList : partition) {
            int i = this.saveBatch(subList);
            successCount += i;
        }
        return successCount;
    }

    public int saveMultiSet(@Param(value="entitys") Collection<E> var1);

    default public int saveUnique(Collection<E> records) {
        return this.saveUnique(records, null);
    }

    default public int saveUnique(Collection<E> records, Comparator<E> comparator) {
        if (records == null || records.isEmpty()) {
            return 0;
        }
        if (comparator == null) {
            return this.saveBatch(new HashSet<E>(records));
        }
        ArrayList<E> list = new ArrayList<E>(records);
        for (int i = 0; i < list.size() - 1; ++i) {
            Object obj1 = list.get(i);
            for (int j = list.size() - 1; j > i; --j) {
                Object obj2 = list.get(j);
                if (comparator.compare(obj1, obj2) != 0) continue;
                list.remove(j);
            }
        }
        return this.saveBatch(list);
    }
}

