/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.mapper;

import com.gitee.fastmybatis.core.FastmybatisContext;
import com.gitee.fastmybatis.core.mapper.Mapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.util.Collection;
import java.util.Objects;
import org.apache.ibatis.annotations.Param;

public interface DeleteMapper<E, I>
extends Mapper<E> {
    public int delete(E var1);

    public int deleteById(I var1);

    default public int deleteByIds(Collection<I> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("parameter 'ids' can not empty");
        }
        Class<?> entityClass = ClassUtil.getSuperInterfaceGenericType(this.getClass(), 0);
        String pkColumnName = FastmybatisContext.getPkColumnName(entityClass);
        return this.deleteByColumn(pkColumnName, ids);
    }

    default public int deleteByColumn(String column, Object value) {
        if (column == null || "".equals(column)) {
            throw new IllegalArgumentException("parameter 'columns' can not blank");
        }
        Objects.requireNonNull(value, "value can not null");
        Query query = value instanceof Collection ? (Query)new Query().in(column, (Collection)value) : (Query)new Query().eq(column, value);
        return this.deleteByQuery(query);
    }

    public int deleteByQuery(@Param(value="query") Query var1);

    public int forceDelete(E var1);

    public int forceDeleteById(I var1);

    public int forceDeleteByQuery(@Param(value="query") Query var1);
}

