/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.mapper;

import com.gitee.fastmybatis.core.mapper.EditMapper;
import com.gitee.fastmybatis.core.mapper.SchMapper;
import java.util.Objects;
import java.util.function.Function;

public interface CrudMapper<E, I>
extends SchMapper<E, I>,
EditMapper<E, I> {
    default public int saveOrUpdate(E entity) {
        return this.saveOrUpdate(entity, this::checkExistById);
    }

    default public int saveOrUpdate(E entity, Function<E, Boolean> existChecker) {
        Objects.requireNonNull(entity, "entity can not null");
        Objects.requireNonNull(existChecker, "existChecker can not null");
        if (existChecker.apply(entity).booleanValue()) {
            return this.update(entity);
        }
        return this.save(entity);
    }

    default public int saveOrUpdateIgnoreNull(E entity) {
        return this.saveOrUpdateIgnoreNull(entity, this::checkExistById);
    }

    default public int saveOrUpdateIgnoreNull(E entity, Function<E, Boolean> existChecker) {
        Objects.requireNonNull(entity, "entity can not null");
        Objects.requireNonNull(existChecker, "existChecker can not null");
        if (existChecker.apply(entity).booleanValue()) {
            return this.updateIgnoreNull(entity);
        }
        return this.saveIgnoreNull(entity);
    }
}

