/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.spi.impl;

import com.gitee.fastmybatis.core.ext.spi.ClassSearch;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.io.ResolverUtil;

public class MapperClassSearch
implements ClassSearch {
    private static final String DEFAULT_MAPPER_PACKAGE = "com.gitee.fastmybatis.core.mapper";
    private static final String[] FILE_STUFF = new String[]{"Mapper", "Dao", "DAO", "Repository"};

    @Override
    public Set<Class<?>> search(Class<?> targetClass, String ... packageName) throws Exception {
        ResolverUtil resolver = new ResolverUtil();
        resolver.findImplementations(targetClass, packageName);
        return resolver.getClasses().stream().filter(this::match).collect(Collectors.toSet());
    }

    @Override
    public boolean match(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        boolean isMapper = com.gitee.fastmybatis.core.mapper.Mapper.class.isAssignableFrom(clazz);
        if (isMapper) {
            return true;
        }
        Mapper annotation = clazz.getAnnotation(Mapper.class);
        if (annotation != null) {
            return true;
        }
        String name = clazz.getName();
        boolean isRightPackage = !name.startsWith(DEFAULT_MAPPER_PACKAGE);
        return isRightPackage && this.hasFileStuff(name);
    }

    public boolean hasFileStuff(String name) {
        for (String stuff : FILE_STUFF) {
            if (!name.endsWith(stuff)) continue;
            return true;
        }
        return false;
    }
}

