/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.spi;

import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.ext.spi.BeanExecutor;
import com.gitee.fastmybatis.core.ext.spi.ClassSearch;
import com.gitee.fastmybatis.core.ext.spi.ConditionValueExecutor;
import com.gitee.fastmybatis.core.ext.spi.MapperBuilder;
import com.gitee.fastmybatis.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class SpiContext {
    private static final Log log = LogFactory.getLog(SpiContext.class);
    private static final String DEFAULT_FILE_NAME = "META-INF/fastmybatis.factories.default";
    private static final String EXT_FILE_NAME = "META-INF/fastmybatis.factories";
    private static final Map<String, Object> instanceMap = new ConcurrentHashMap<String, Object>(8);
    private static volatile boolean init = false;
    private static final Object LOCK = new Object();

    public static ConditionValueExecutor getConditionValueExecutor() {
        return (ConditionValueExecutor)SpiContext.getService(SpiKey.CONDITION_VALUE_EXECUTOR);
    }

    public static ClassSearch getClassSearch() {
        return (ClassSearch)SpiContext.getService(SpiKey.CLASS_SEARCH);
    }

    public static BeanExecutor getBeanExecutor() {
        return (BeanExecutor)SpiContext.getService(SpiKey.BEAN_EXECUTOR);
    }

    public static MapperBuilder getMapperBuilder() {
        return (MapperBuilder)SpiContext.getService(SpiKey.MAPPER_BUILDER);
    }

    private static <T> T getService(SpiKey spiKey) {
        return SpiContext.getService(spiKey.getKey());
    }

    public static <T> T getService(String beanName) {
        SpiContext.doInit();
        return (T)instanceMap.get(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInit() {
        if (!init) {
            Object object = LOCK;
            synchronized (object) {
                if (!init) {
                    SpiContext.init(DEFAULT_FILE_NAME);
                    SpiContext.init(EXT_FILE_NAME);
                    init = true;
                }
            }
        }
    }

    private static void init(String filename) {
        InputStream inputStream = null;
        try {
            inputStream = Resources.getResourceAsStream((String)filename);
        }
        catch (IOException e) {
            return;
        }
        if (inputStream == null) {
            return;
        }
        try {
            List<String> lines = IOUtil.readLines(inputStream, StandardCharsets.UTF_8);
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new RuntimeException("fastmybatis.factories config error, must be key=value pattern");
                }
                String key = split[0];
                String className = split[1];
                Class<?> aClass = Class.forName(className);
                Object instance = aClass.newInstance();
                instanceMap.put(key, instance);
            }
        }
        catch (Exception e) {
            log.error("read lines error", (Throwable)e);
            throw new RuntimeException("init spi error", e);
        }
    }

    public static enum SpiKey {
        CLASS_SEARCH(ClassSearch.class),
        MAPPER_BUILDER(MapperBuilder.class),
        BEAN_EXECUTOR(BeanExecutor.class),
        CONDITION_VALUE_EXECUTOR(ConditionValueExecutor.class);

        private final String key;

        private SpiKey(Class<?> clazz) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("clazz must an interface");
            }
            this.key = FieldUtil.lowerFirstLetter(clazz.getSimpleName());
        }

        public String getKey() {
            return this.key;
        }
    }
}

