/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.util;

import com.gitee.fastmybatis.core.util.IOUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static String LOG_TAG;
    private static String UTF8;

    private VelocityUtil() {
    }

    public static String generate(VelocityContext context, InputStream inputStream) {
        try {
            return VelocityUtil.generate(context, inputStream, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String generate(VelocityContext context, InputStream inputStream, String charset) throws UnsupportedEncodingException {
        return VelocityUtil.generate(context, new InputStreamReader(inputStream, charset));
    }

    public static String generate(VelocityContext context, Reader reader) {
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)writer, (String)LOG_TAG, (Reader)reader);
        IOUtil.closeQuietly(writer, reader);
        return writer.toString();
    }

    public static String generate(VelocityContext context, String template) {
        return VelocityUtil.generate(context, new StringReader(template));
    }

    static {
        Velocity.init();
        LOG_TAG = "fastmybatis";
        UTF8 = "UTF-8";
    }
}

