/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.util;

import com.gitee.fastmybatis.core.ext.code.util.JavaType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaTypeUtil {
    private static Map<String, JavaType> javaTypeMap = new HashMap<String, JavaType>();
    private static Map<String, String> mybatisTypeMap = new HashMap<String, String>();
    private static Set<String> javaTypeSet = new HashSet<String>();

    private JavaTypeUtil() {
    }

    private static void initMybatisTypeMap() {
        Set<Map.Entry<String, JavaType>> entrySet = javaTypeMap.entrySet();
        for (Map.Entry<String, JavaType> entry : entrySet) {
            String type = entry.getKey();
            String boxType = entry.getValue().getBoxType();
            String mybatisType = entry.getValue().getMybatisType();
            JavaTypeUtil.addMybatisType(type, mybatisType);
            JavaTypeUtil.addMybatisType(boxType, mybatisType);
        }
    }

    public static void addMybatisType(String javaType, String mybatisType) {
        mybatisTypeMap.put(javaType, mybatisType);
    }

    public static void addJavaType(String baseType, String boxType, String mybatisType) {
        javaTypeMap.put(baseType, new JavaType(baseType, boxType, mybatisType));
        JavaTypeUtil.addJavaType(baseType);
        JavaTypeUtil.addJavaType(boxType);
    }

    public static String convertToJavaBoxType(String baseType) {
        JavaType type = javaTypeMap.get(baseType);
        return type == null ? baseType : type.getBoxType();
    }

    public static String convertToMyBatisJdbcType(String javaType) {
        String mybatisJdbcType = mybatisTypeMap.get(javaType);
        return mybatisJdbcType == null ? "VARCHAR" : mybatisJdbcType;
    }

    public static void addJavaType(String type) {
        javaTypeSet.add(type);
    }

    public static Set<String> getJavaTypes() {
        return javaTypeSet;
    }

    public static boolean isJavaType(String type) {
        return javaTypeSet.contains(type);
    }

    static {
        JavaTypeUtil.addJavaType("boolean", "Boolean", "BIT");
        JavaTypeUtil.addJavaType("byte", "Byte", "TINYINT");
        JavaTypeUtil.addJavaType("short", "Short", "SMALLINT");
        JavaTypeUtil.addJavaType("char", "Character", "VARCHAR");
        JavaTypeUtil.addJavaType("int", "Integer", "INTEGER");
        JavaTypeUtil.addJavaType("long", "Long", "BIGINT");
        JavaTypeUtil.addJavaType("float", "Float", "FLOAT");
        JavaTypeUtil.addJavaType("double", "Double", "DOUBLE");
        JavaTypeUtil.addJavaType("byte[]", "Byte[]", "BINARY");
        JavaTypeUtil.addJavaType("String", "String", "VARCHAR");
        JavaTypeUtil.addJavaType("List", "String", "VARCHAR");
        JavaTypeUtil.addJavaType("Set", "String", "VARCHAR");
        JavaTypeUtil.addJavaType("Collection", "String", "VARCHAR");
        JavaTypeUtil.addJavaType("Date", "Date", "TIMESTAMP");
        JavaTypeUtil.addJavaType("Time", "Time", "TIMESTAMP");
        JavaTypeUtil.addJavaType("Timestamp", "Timestamp", "TIMESTAMP");
        JavaTypeUtil.addJavaType("Instant", "Instant", "TIMESTAMP");
        JavaTypeUtil.addJavaType("LocalDateTime", "LocalDateTime", "TIMESTAMP");
        JavaTypeUtil.addJavaType("OffsetDateTime", "OffsetDateTime", "TIMESTAMP");
        JavaTypeUtil.addJavaType("ZonedDateTime", "ZonedDateTime", "TIMESTAMP");
        JavaTypeUtil.addJavaType("LocalDate", "LocalDate", "DATE");
        JavaTypeUtil.addJavaType("BigDecimal", "BigDecimal", "DECIMAL");
        JavaTypeUtil.addJavaType("Clob", "Clob", "CLOB");
        JavaTypeUtil.addJavaType("Blob", "Blob", "BLOB");
        JavaTypeUtil.initMybatisTypeMap();
    }
}

