/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.util;

import com.gitee.fastmybatis.annotation.Column;
import com.gitee.fastmybatis.annotation.LogicDeleteStrategy;
import com.gitee.fastmybatis.annotation.Pk;
import com.gitee.fastmybatis.annotation.PkStrategy;
import com.gitee.fastmybatis.annotation.Table;
import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.annotation.LazyFetch;
import com.gitee.fastmybatis.core.annotation.LogicDelete;
import com.gitee.fastmybatis.core.ext.code.generator.LogicDeleteDefinition;
import com.gitee.fastmybatis.core.util.ClassUtil;
import com.gitee.fastmybatis.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;

public class FieldUtil {
    private static final String UUID_NAME = "uuid";
    private static final String INCREMENT_NAME = "increment";
    private static final String SEQUENCE_NAME = "seq";
    private static final String STRING_TYPE = "String";
    private static final String DOT = ".";
    public static final char UNDERLINE = '_';

    private FieldUtil() {
    }

    public static String dotFilter(String field) {
        if (FieldUtil.isNotEmpty(field) && field.contains(DOT)) {
            String[] words = field.split("\\.");
            StringBuilder ret = new StringBuilder();
            for (String str : words) {
                ret.append(FieldUtil.upperFirstLetter(str));
            }
            return ret.toString();
        }
        return field;
    }

    public static String upperFirstLetter(String str) {
        if (FieldUtil.isNotEmpty(str)) {
            String firstUpper = String.valueOf(str.charAt(0)).toUpperCase();
            str = firstUpper + str.substring(1);
        }
        return str;
    }

    public static String lowerFirstLetter(String str) {
        if (FieldUtil.isNotEmpty(str)) {
            String firstLower = String.valueOf(str.charAt(0)).toLowerCase();
            str = firstLower + str.substring(1);
        }
        return str;
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            boolean needToLower;
            char c = param.charAt(i);
            int preIndex = i - 1;
            int nextIndex = i + 1;
            boolean bl = needToLower = Character.isUpperCase(c) && preIndex > 0 && Character.isLowerCase(param.charAt(preIndex)) || Character.isUpperCase(c) && nextIndex < len && Character.isLowerCase(param.charAt(nextIndex));
            if (needToLower) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String formatField(String field) {
        String[] arr = field.split("\\.");
        if (arr.length == 2) {
            field = arr[1];
        }
        field = StringUtil.trimLeadingCharacter(field, '`');
        field = StringUtil.trimTrailingCharacter(field, '`');
        field = StringUtil.trimLeadingCharacter(field, '\"');
        field = StringUtil.trimTrailingCharacter(field, '\"');
        field = StringUtil.trimLeadingCharacter(field, '[');
        field = StringUtil.trimTrailingCharacter(field, ']');
        return field;
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isTransientField(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static boolean isNotEmpty(String s) {
        return !FieldUtil.isEmpty(s);
    }

    public static boolean isPk(Field field, FastmybatisConfig config) {
        String pkName = FieldUtil.getPkAnnotation(field).map(Pk::name).orElse("");
        if ("".equals(pkName)) {
            pkName = config.getGlobalIdName();
        }
        return pkName.equalsIgnoreCase(FieldUtil.camelToUnderline(field.getName()));
    }

    public static boolean isPkStrategyNone(Field field, FastmybatisConfig config) {
        if (!FieldUtil.isPk(field, config)) {
            return false;
        }
        return FieldUtil.getPkStrategy(field).orElse(PkStrategy.INCREMENT) == PkStrategy.NONE;
    }

    public static Optional<Table> getTableAnnotation(Field field) {
        Class<?> entityClass = field.getDeclaringClass();
        return FieldUtil.getTableAnnotation(entityClass);
    }

    public static Optional<Table> getTableAnnotation(Class<?> entityClass) {
        Table table = ClassUtil.findAnnotation(entityClass, Table.class);
        return Optional.ofNullable(table);
    }

    public static Optional<PkStrategy> getPkStrategy(Field field) {
        return FieldUtil.getPkAnnotation(field).map(Pk::strategy);
    }

    public static Optional<Pk> getPkAnnotation(Field field) {
        return FieldUtil.getTableAnnotation(field).map(Table::pk);
    }

    public static boolean isIncrement(Field field) {
        return FieldUtil.getPkStrategy(field).orElse(PkStrategy.NONE) == PkStrategy.INCREMENT;
    }

    public static boolean isUuid(Field field) {
        return FieldUtil.getPkStrategy(field).orElse(PkStrategy.NONE) == PkStrategy.UUID;
    }

    public static boolean isSequence(Field field) {
        return FieldUtil.isNotEmpty(FieldUtil.getSequenceName(field));
    }

    public static String getSequenceName(Field field) {
        return FieldUtil.getTableAnnotation(field).map(Table::pk).map(Pk::sequenceName).orElse(null);
    }

    public static boolean isVersionColumn(Field field) {
        return FieldUtil.getColumnAnnotation(field).map(Column::version).orElse(false);
    }

    public static String getColumnName(Field field, FastmybatisConfig config) {
        String name = FieldUtil.getColumnAnnotation(field).map(Column::name).orElse(null);
        if (FieldUtil.isEmpty(name)) {
            String javaFieldName = field.getName();
            name = config.isCamel2underline() ? FieldUtil.camelToUnderline(field.getName()) : javaFieldName;
        }
        return name;
    }

    public static Optional<Column> getColumnAnnotation(Field field) {
        return Optional.ofNullable(field.getAnnotation(Column.class));
    }

    public static boolean hasTableAnnotation(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        return ClassUtil.findAnnotation(declaringClass, Table.class) != null;
    }

    public static String getLazyEntityColumnName(Field field, FastmybatisConfig config) {
        String column;
        Boolean lazy = FieldUtil.getColumnAnnotation(field).map(Column::lazyFetch).orElse(false);
        if (lazy.booleanValue()) {
            return FieldUtil.getColumnName(field, config);
        }
        LazyFetch annotation = field.getAnnotation(LazyFetch.class);
        if (annotation != null && "".equals(column = annotation.column())) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9aLazyFetch.column\u503c");
        }
        return null;
    }

    public static LogicDeleteDefinition getLogicDeleteDefinition(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && column.logicDelete()) {
            LogicDeleteDefinition logicDeleteDefinition = new LogicDeleteDefinition();
            logicDeleteDefinition.setLogicDeleteStrategy(column.logicDeleteStrategy().getCode());
            logicDeleteDefinition.setDeleteValue(column.deleteValue());
            logicDeleteDefinition.setNotDeleteValue(column.notDeleteValue());
            return logicDeleteDefinition;
        }
        LogicDelete logicDelete = field.getAnnotation(LogicDelete.class);
        if (logicDelete != null) {
            LogicDeleteDefinition logicDeleteDefinition = new LogicDeleteDefinition();
            logicDeleteDefinition.setLogicDeleteStrategy(LogicDeleteStrategy.FIXED_VALUE.getCode());
            logicDeleteDefinition.setDeleteValue(logicDelete.deleteValue());
            logicDeleteDefinition.setNotDeleteValue(logicDelete.notDeleteValue());
            return logicDeleteDefinition;
        }
        return null;
    }
}

