/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.annotation.Table;
import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.code.generator.ColumnSelector;
import com.gitee.fastmybatis.core.ext.code.generator.TableDefinition;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.util.StringUtil;
import java.util.Optional;

public class TableSelector {
    private final ColumnSelector columnSelector;
    private final Class<?> entityClass;
    private final FastmybatisConfig config;

    public TableSelector(Class<?> entityClass, FastmybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("FastmybatisConfig\u4e0d\u80fd\u4e3anull");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass\u4e0d\u80fd\u4e3anull");
        }
        this.entityClass = entityClass;
        this.config = config;
        this.columnSelector = new ColumnSelector(entityClass, config);
    }

    public TableDefinition getTableDefinition() {
        TableDefinition tableDefinition = new TableDefinition();
        String tableName = this.getTableName();
        tableDefinition.setTableName(tableName);
        tableDefinition.setColumnDefinitions(this.columnSelector.getColumnDefinitions());
        tableDefinition.setAssociationDefinitions(this.columnSelector.getAssociationDefinitions());
        return tableDefinition;
    }

    private String getTableName() {
        String tableName = null;
        Optional<Table> tableAnnotation = FieldUtil.getTableAnnotation(this.entityClass);
        if (tableAnnotation.isPresent()) {
            tableName = tableAnnotation.get().name();
        }
        if (StringUtil.isEmpty(tableName)) {
            String javaBeanName = this.entityClass.getSimpleName();
            if (this.config.isCamel2underline()) {
                tableName = FieldUtil.camelToUnderline(javaBeanName);
            }
        }
        return tableName;
    }
}

