/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.FastmybatisContext;
import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.code.generator.AssociationDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.ColumnDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.LogicDeleteDefinition;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.ext.code.util.JavaTypeUtil;
import com.gitee.fastmybatis.core.ext.code.util.ReflectUtil;
import com.gitee.fastmybatis.core.ext.exception.GenCodeException;
import com.gitee.fastmybatis.core.ext.info.EntityInfo;
import com.gitee.fastmybatis.core.handler.BaseEnum;
import com.gitee.fastmybatis.core.handler.BaseFill;
import com.gitee.fastmybatis.core.handler.EnumTypeHandler;
import com.gitee.fastmybatis.core.handler.FillType;
import com.gitee.fastmybatis.core.util.ClassUtil;
import com.gitee.fastmybatis.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ColumnSelector {
    private static final String SELECT_GET = "%s.getById";
    private static final String FETCH_GET = "%s.forceById";
    private final Class<?> entityClass;
    private final FastmybatisConfig config;

    public ColumnSelector(Class<?> entityClass, FastmybatisConfig config) {
        this.entityClass = entityClass;
        this.config = config;
    }

    private String getColumnType(Field field) {
        String columnType = field.getType().getSimpleName();
        if ("Object".equals(columnType)) {
            columnType = ClassUtil.getSuperClassGenricType(this.entityClass, 0).getSimpleName();
        }
        return columnType;
    }

    private String getColumnFullType(Field field) {
        String fullType = field.getType().getName();
        if ("java.lang.Object".equals(fullType)) {
            fullType = ClassUtil.getSuperClassGenricType(this.entityClass, 0).getSimpleName();
        }
        return fullType;
    }

    private boolean isEnum(Field field) {
        Class<?> enumType = field.getType();
        boolean isEnum = enumType.isEnum();
        if (isEnum) {
            this.checkEnum(enumType);
        }
        return isEnum;
    }

    private void checkEnum(Class<?> enumType) {
        Class<?>[] arr;
        boolean isBaseEnum = false;
        Class<BaseEnum> baseEnumClass = BaseEnum.class;
        for (Class<?> type : arr = enumType.getInterfaces()) {
            if (!type.equals(baseEnumClass)) continue;
            isBaseEnum = true;
            break;
        }
        if (!isBaseEnum) {
            throw new GenCodeException("\u679a\u4e3e\u7c7b\uff1a" + enumType.getName() + "\u5fc5\u987b\u5b9e\u73b0" + baseEnumClass.getName() + "\u63a5\u53e3");
        }
    }

    private String getColumnName(Field field) {
        return FieldUtil.getColumnName(field, this.config);
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        List<Field> fields = ReflectUtil.getDeclaredFields(this.entityClass);
        ArrayList<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>(fields.size());
        int pkCount = 0;
        for (Field field : fields) {
            ColumnDefinition columnDefinition2 = this.buildColumnDefinition(field);
            if (columnDefinition2 == null) continue;
            columnDefinitionList.add(columnDefinition2);
            if (!columnDefinition2.getIsPk()) continue;
            ++pkCount;
        }
        if (pkCount == 0) {
            Optional<ColumnDefinition> id = columnDefinitionList.stream().filter(columnDefinition -> this.config.getGlobalIdName().equals(columnDefinition.getColumnName())).findFirst();
            if (id.isPresent()) {
                ColumnDefinition pk = id.get();
                pk.setIsPk(true);
                pk.setIsIdentity(this.config.isGlobalIdIncrement());
            } else {
                ColumnDefinition first = (ColumnDefinition)columnDefinitionList.get(0);
                first.setIsPk(true);
            }
        }
        return columnDefinitionList;
    }

    public List<AssociationDefinition> getAssociationDefinitions() {
        List<Field> fields = ReflectUtil.getDeclaredFields(this.entityClass);
        ArrayList<AssociationDefinition> associations = new ArrayList<AssociationDefinition>(8);
        for (Field field : fields) {
            AssociationDefinition associationDefinition = this.buildAssociationDefinition(field);
            if (associationDefinition == null) continue;
            associations.add(associationDefinition);
        }
        return associations;
    }

    protected AssociationDefinition buildAssociationDefinition(Field field) {
        boolean isTransient = FieldUtil.isTransientField(field);
        if (isTransient) {
            return null;
        }
        if (!FieldUtil.hasTableAnnotation(field)) {
            return null;
        }
        Class<?> clazz = field.getType();
        String column = FieldUtil.getLazyEntityColumnName(field, this.config);
        if (StringUtil.isEmpty(column)) {
            return null;
        }
        String property = field.getName();
        Class<?> mapperClass = ExtContext.getMapperClass(clazz);
        String namespace = mapperClass.getName();
        String temp = this.config.getIgnoreLogicDeleteWithAssociation() ? FETCH_GET : SELECT_GET;
        String select = String.format(temp, namespace);
        AssociationDefinition associationDefinition = new AssociationDefinition();
        associationDefinition.setColumn(column);
        associationDefinition.setProperty(property);
        associationDefinition.setSelect(select);
        return associationDefinition;
    }

    protected ColumnDefinition buildColumnDefinition(Field field) {
        boolean isTransient = FieldUtil.isTransientField(field);
        if (isTransient) {
            return null;
        }
        ColumnDefinition columnDefinition = new ColumnDefinition();
        String columnName = this.getColumnName(field);
        String columnType = this.getColumnType(field);
        String fullType = this.getColumnFullType(field);
        boolean isEnum = this.isEnum(field);
        BaseFill<?> fill = this.getFill(columnName, field);
        if (!isEnum && !JavaTypeUtil.isJavaType(columnType) && fill == null) {
            return null;
        }
        columnDefinition.setJavaFieldName(field.getName());
        columnDefinition.setColumnName(columnName);
        columnDefinition.setType(columnType);
        columnDefinition.setFullType(fullType);
        columnDefinition.setEnum(isEnum);
        columnDefinition.setIgnoreUpdate(this.config.getIgnoreUpdateColumns().contains(columnName));
        if (isEnum) {
            columnDefinition.setTypeHandler(EnumTypeHandler.class.getName());
            columnDefinition.setFillType(FillType.UPDATE);
        }
        boolean isPk = FieldUtil.isPk(field, this.config);
        columnDefinition.setIsPk(isPk);
        if (isPk) {
            String sequenceName = FieldUtil.getSequenceName(field);
            if (StringUtil.hasText(sequenceName)) {
                columnDefinition.setSequenceName(sequenceName);
            } else if (FieldUtil.isIncrement(field)) {
                columnDefinition.setIsIdentity(true);
            } else if (FieldUtil.isUuid(field)) {
                columnDefinition.setIsUuid(true);
                columnDefinition.setIsAuto(false);
            } else {
                columnDefinition.setIsAuto(true);
            }
            this.setEntityInfo(columnDefinition);
        }
        boolean isVersionColumn = FieldUtil.isVersionColumn(field);
        columnDefinition.setIsVersion(isVersionColumn);
        this.bindLogicDeleteColumnInfo(columnDefinition, field);
        this.bindFill(columnDefinition, fill);
        return columnDefinition;
    }

    private void setEntityInfo(ColumnDefinition columnDefinition) {
        EntityInfo entityInfo = new EntityInfo();
        entityInfo.setPkColumnName(columnDefinition.getColumnName());
        entityInfo.setPkJavaName(columnDefinition.getJavaFieldName());
        FastmybatisContext.setEntityInfo(this.entityClass, entityInfo);
    }

    private void bindLogicDeleteColumnInfo(ColumnDefinition columnDefinition, Field field) {
        LogicDeleteDefinition logicDeleteDefinition = FieldUtil.getLogicDeleteDefinition(field);
        if (logicDeleteDefinition == null) {
            return;
        }
        columnDefinition.setIsLogicDelete(true);
        String deleteValue = logicDeleteDefinition.getDeleteValue();
        String notDeleteValue = logicDeleteDefinition.getNotDeleteValue();
        String logicDeleteStrategy = logicDeleteDefinition.getLogicDeleteStrategy();
        if ("".equals(deleteValue)) {
            deleteValue = this.config.getLogicDeleteValue();
        }
        if ("".equals(notDeleteValue)) {
            notDeleteValue = this.config.getLogicNotDeleteValue();
        }
        if ("".equals(logicDeleteStrategy)) {
            logicDeleteStrategy = this.config.getLogicDeleteStrategy();
        }
        Object delVal = StringUtil.isInteger(deleteValue) ? Integer.valueOf(deleteValue) : deleteValue;
        columnDefinition.setLogicDeleteValue(delVal);
        Object notDelVal = StringUtil.isInteger(notDeleteValue) ? Integer.valueOf(notDeleteValue) : notDeleteValue;
        columnDefinition.setLogicNotDeleteValue(notDelVal);
        columnDefinition.setLogicDeleteStrategy(logicDeleteStrategy);
    }

    private BaseFill<?> getFill(String columnName, Field field) {
        return this.config.getFill(this.entityClass, field, columnName);
    }

    private void bindFill(ColumnDefinition columnDefinition, BaseFill<?> fill) {
        if (fill != null) {
            FillType fillType = fill.getFillType();
            columnDefinition.setTypeHandler(((Object)fill).getClass().getName());
            columnDefinition.setFillType(fillType);
            columnDefinition.setIsCustomFill(fillType == FillType.INSERT || fillType == FillType.UPDATE);
        }
    }
}

