/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.ext.code.util.JavaTypeUtil;
import com.gitee.fastmybatis.core.handler.FillType;
import com.gitee.fastmybatis.core.handler.Identitys;

public class ColumnDefinition {
    private static final String PREFIX = "entity.";
    private static final String MYBATIS_JDBC_TYPE = ", jdbcType=%s";
    private String javaFieldName;
    private String columnName;
    private String type;
    private String fullType;
    private boolean isIdentity;
    private boolean isAuto;
    private boolean isUuid;
    private boolean isSequence;
    private String sequenceName;
    private boolean isCustomFill;
    private boolean isPk;
    private boolean isEnum;
    private boolean isVersion;
    @Deprecated
    private boolean isLogicDelete;
    private boolean isIgnoreUpdate;
    private String logicDeleteStrategy;
    private Object logicDeleteValue;
    private Object logicNotDeleteValue;
    private String comment;
    private String typeHandler;
    private FillType fillType;
    private int orderIndex = 1;

    public boolean getIsCustomFillUpdate() {
        return this.getIsCustomFill() && this.fillType == FillType.UPDATE;
    }

    public boolean getIsInsertColumn() {
        return !this.isIdentity && !this.isIgnoreUpdate;
    }

    public boolean getIsUpdateColumn() {
        return !this.isPk && !this.isIgnoreUpdate;
    }

    public boolean getIsCustomIdFill() {
        return this.isAuto && this.typeHandler != null;
    }

    public String getCustomIdTypeHandlerValue() {
        return "#{" + this.getJavaFieldName() + ", typeHandler=com.gitee.fastmybatis.core.handler.CustomIdTypeHandler}";
    }

    public Object getAutoId() {
        try {
            Object object = Identitys.get();
            return object;
        }
        finally {
            Identitys.remove();
        }
    }

    public String getLogicDeleteValueString() {
        return this.formatValue(this.logicDeleteValue);
    }

    public String getLogicNotDeleteValueString() {
        return this.formatValue(this.logicNotDeleteValue);
    }

    public String getJdbcTypeProperty() {
        return this.typeHandler == null ? "jdbcType=\"" + this.getMybatisJdbcType() + "\"" : "";
    }

    public String getJavaTypeProperty() {
        return this.typeHandler != null ? "javaType=\"" + this.getFullType() + "\"" : "";
    }

    public String getTypeHandlerProperty() {
        return this.typeHandler != null ? " typeHandler=\"" + this.typeHandler + "\" " : "";
    }

    private String getTypeHandlerValue(FillType type) {
        return this.hasTypeHandler(type) ? ", typeHandler=" + this.typeHandler : "";
    }

    public boolean getHasTypeHandlerInsert() {
        return this.hasTypeHandler(FillType.INSERT);
    }

    public boolean getHasTypeHandlerUpdate() {
        return this.hasTypeHandler(FillType.UPDATE);
    }

    private boolean hasTypeHandler(FillType type) {
        return this.typeHandler != null && FillType.checkPower(this.fillType, type);
    }

    public String getMybatisInsertValue() {
        return this.getMybatisValue(FillType.INSERT);
    }

    public String getMybatisInsertValuePrefix() {
        return this.getMybatisValue(FillType.INSERT, PREFIX);
    }

    public String getMybatisUpdateValue() {
        return this.getMybatisValue(FillType.UPDATE);
    }

    public String getMybatisUpdateValuePrefix() {
        return this.getMybatisValue(FillType.UPDATE, PREFIX);
    }

    public String getMybatisSelectValue() {
        return this.getMybatisValue(FillType.SELECT);
    }

    private String getMybatisValue(FillType fillType) {
        return this.getMybatisValue(fillType, "");
    }

    private String getMybatisValue(FillType fillType, String prefix) {
        if (this.isVersion) {
            return this.columnName + "+1";
        }
        StringBuilder mybatisValue = new StringBuilder();
        mybatisValue.append("#{" + prefix + this.getJavaFieldName()).append(this.getTypeHandlerValue(fillType)).append("}");
        return mybatisValue.toString();
    }

    public boolean getIsVersion() {
        return this.isVersion;
    }

    public void setIsVersion(boolean isVersion) {
        this.isVersion = isVersion;
    }

    public boolean getIsIdentityPk() {
        return this.isPk && this.isIdentity;
    }

    public boolean getIsSequence() {
        return this.isSequence;
    }

    public void setIsSequence(boolean isSequence) {
        this.isSequence = isSequence;
    }

    public String getJavaFieldNameUF() {
        return FieldUtil.upperFirstLetter(this.getJavaFieldName());
    }

    public String getJavaFieldName() {
        return this.javaFieldName;
    }

    public String getJavaType() {
        return this.type;
    }

    public String getJavaTypeBox() {
        return JavaTypeUtil.convertToJavaBoxType(this.type);
    }

    public String getMybatisJdbcType() {
        return JavaTypeUtil.convertToMyBatisJdbcType(this.type);
    }

    public void setJavaFieldName(String javaFieldName) {
        this.javaFieldName = javaFieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getIsIdentity() {
        return this.isIdentity;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean getIsPk() {
        return this.isPk;
    }

    public void setIsPk(boolean isPk) {
        this.isPk = isPk;
    }

    public boolean getIsUuid() {
        return this.isUuid;
    }

    public void setIsUuid(boolean isUuid) {
        this.isUuid = isUuid;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean getIsEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public String getFullType() {
        return this.fullType;
    }

    public void setFullType(String fullType) {
        this.fullType = fullType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
    }

    public void setTypeHandler(String typeHandler) {
        this.typeHandler = typeHandler;
    }

    public String getLogicDeleteStrategy() {
        return this.logicDeleteStrategy;
    }

    public void setLogicDeleteStrategy(String logicDeleteStrategy) {
        this.logicDeleteStrategy = logicDeleteStrategy;
    }

    @Deprecated
    public void setIsLogicDelete(boolean isLogicDelete) {
        this.isLogicDelete = isLogicDelete;
    }

    @Deprecated
    public boolean getIsLogicDelete() {
        return this.isLogicDelete;
    }

    public Object getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(Object logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public Object getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(Object logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    private String formatValue(Object value) {
        if (value instanceof String) {
            return "'" + value + "'";
        }
        return String.valueOf(value);
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public void setOrderIndex(int orderIndex) {
        this.orderIndex = orderIndex;
    }

    public boolean getIsAuto() {
        return this.isAuto;
    }

    public void setIsAuto(boolean isAuto) {
        this.isAuto = isAuto;
    }

    public boolean isIgnoreUpdate() {
        return this.isIgnoreUpdate;
    }

    public void setIgnoreUpdate(boolean ignoreUpdate) {
        this.isIgnoreUpdate = ignoreUpdate;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
        this.isSequence = sequenceName != null && sequenceName.length() > 0;
    }

    public boolean getIsCustomFill() {
        return this.isCustomFill;
    }

    public void setIsCustomFill(boolean isCustomFill) {
        this.isCustomFill = isCustomFill;
    }
}

