/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.client;

import com.gitee.fastmybatis.core.ext.code.NotEntityException;
import com.gitee.fastmybatis.core.ext.code.client.ClientParam;
import com.gitee.fastmybatis.core.ext.code.generator.MapperContext;
import com.gitee.fastmybatis.core.ext.code.generator.TableDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.TableSelector;
import com.gitee.fastmybatis.core.ext.code.util.VelocityUtil;
import com.gitee.fastmybatis.core.util.IOUtil;
import com.gitee.fastmybatis.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.ibatis.io.Resources;
import org.apache.velocity.VelocityContext;

public class FileCodeGenerator {
    public String generateCode(ClientParam clientParam) throws NotEntityException, IOException {
        String finalContent = this.buildTemplateInputStream(clientParam);
        MapperContext sqlContext = this.buildClientSQLContextList(clientParam);
        VelocityContext context = new VelocityContext();
        TableDefinition tableDefinition = sqlContext.getTableDefinition();
        context.put("context", (Object)sqlContext);
        context.put("table", (Object)tableDefinition);
        context.put("pk", (Object)tableDefinition.getPkColumn());
        context.put("columns", tableDefinition.getTableColumns());
        context.put("allColumns", tableDefinition.getAllColumns());
        context.put("countExpression", (Object)clientParam.getCountExpression());
        context.put("associations", tableDefinition.getAssociationDefinitions());
        return VelocityUtil.generate(context, finalContent);
    }

    private String buildTemplateInputStream(ClientParam clientParam) throws IOException {
        String templateContent = clientParam.getTemplateContent();
        if (StringUtil.hasText(clientParam.getGlobalVmLocation())) {
            InputStream inputStream = Resources.getResourceAsStream((String)clientParam.getGlobalVmLocation());
            return this.mergeGlobalVm(templateContent, IOUtil.toString(inputStream, StandardCharsets.UTF_8), clientParam.getGlobalVmPlaceholder());
        }
        return templateContent;
    }

    private String mergeGlobalVm(String templateContent, String globalVmContent, String placeholder) throws IOException {
        return templateContent.replace(placeholder, globalVmContent);
    }

    private MapperContext buildClientSQLContextList(ClientParam clientParam) throws NotEntityException {
        Class<?> entityClass = clientParam.getEntityClass();
        if (entityClass == Object.class || entityClass == Void.class) {
            throw new NotEntityException();
        }
        TableSelector tableSelector = new TableSelector(entityClass, clientParam.getConfig());
        TableDefinition tableDefinition = tableSelector.getTableDefinition();
        MapperContext context = new MapperContext(tableDefinition);
        String namespace = this.buildNamespace(clientParam.getMapperClass());
        context.setClassName(entityClass.getName());
        context.setClassSimpleName(entityClass.getSimpleName());
        context.setPackageName(entityClass.getPackage().getName());
        context.setNamespace(namespace);
        return context;
    }

    private String buildNamespace(Class<?> mapperClass) {
        return mapperClass.getName();
    }
}

