/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.MapperLocationsBuilder;
import com.gitee.fastmybatis.core.ext.MyBatisResource;
import com.gitee.fastmybatis.core.util.DbUtil;
import com.gitee.fastmybatis.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.datasource.DataSourceFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.loader.ProxyFactory;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.AutoMappingUnknownColumnBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.xml.sax.EntityResolver;

public class XMLConfigBuilderExt
extends BaseBuilder {
    protected boolean parsed;
    protected final XPathParser parser;
    protected String environment;
    protected final ReflectorFactory localReflectorFactory = new DefaultReflectorFactory();
    private String basePackage;
    private FastmybatisConfig config;
    private String dialect;
    private MapperLocationsBuilder mapperLocationsBuilder;

    public XMLConfigBuilderExt(Reader reader) {
        this(reader, null, null);
    }

    public XMLConfigBuilderExt(Reader reader, String environment) {
        this(reader, environment, null);
    }

    public XMLConfigBuilderExt(Reader reader, String environment, Properties props) {
        this(new XPathParser(reader, true, props, (EntityResolver)new XMLMapperEntityResolver()), environment, props);
    }

    public XMLConfigBuilderExt(InputStream inputStream, String environment, Properties props, String basePackage, FastmybatisConfig config, String dialect) {
        this(new XPathParser(inputStream, true, props, (EntityResolver)new XMLMapperEntityResolver()), environment, props);
        this.basePackage = basePackage;
        this.config = config;
        this.dialect = dialect;
        this.mapperLocationsBuilder = new MapperLocationsBuilder(config);
    }

    protected XMLConfigBuilderExt(XPathParser parser, String environment, Properties props) {
        super(new Configuration());
        ErrorContext.instance().resource("SQL Mapper Configuration");
        this.configuration.setVariables(props);
        this.parsed = false;
        this.environment = environment;
        this.parser = parser;
    }

    public Configuration parse() {
        if (this.parsed) {
            throw new BuilderException("Each XMLConfigBuilderExt can only be used once.");
        }
        this.parsed = true;
        this.parseConfiguration(this.parser.evalNode("/configuration"));
        return this.configuration;
    }

    protected void parseConfiguration(XNode root) {
        try {
            this.propertiesElement(root.evalNode("properties"));
            Properties settings = this.settingsAsProperties(root.evalNode("settings"));
            this.loadCustomVfs(settings);
            this.loadCustomLogImpl(settings);
            this.typeAliasesElement(root.evalNode("typeAliases"));
            this.pluginElement(root.evalNode("plugins"));
            this.objectFactoryElement(root.evalNode("objectFactory"));
            this.objectWrapperFactoryElement(root.evalNode("objectWrapperFactory"));
            this.reflectorFactoryElement(root.evalNode("reflectorFactory"));
            this.settingsElement(settings);
            this.environmentsElement(root.evalNode("environments"));
            this.databaseIdProviderElement(root.evalNode("databaseIdProvider"));
            this.typeHandlerElement(root.evalNode("typeHandlers"));
            this.mapperElement(root.evalNode("mappers"));
        }
        catch (Exception e) {
            throw new BuilderException("Error parsing SQL Mapper Configuration. Cause: " + e, (Throwable)e);
        }
    }

    protected Properties settingsAsProperties(XNode context) {
        if (context == null) {
            return new Properties();
        }
        Properties props = context.getChildrenAsProperties();
        MetaClass metaConfig = MetaClass.forClass(Configuration.class, (ReflectorFactory)this.localReflectorFactory);
        for (Object key : props.keySet()) {
            if (metaConfig.hasSetter(String.valueOf(key))) continue;
            throw new BuilderException("The setting " + key + " is not known.  Make sure you spelled it correctly (case sensitive).");
        }
        return props;
    }

    protected void loadCustomVfs(Properties props) throws ClassNotFoundException {
        String value = props.getProperty("vfsImpl");
        if (value != null) {
            String[] clazzes;
            for (String clazz : clazzes = value.split(",")) {
                if (clazz.isEmpty()) continue;
                Class vfsImpl = Resources.classForName((String)clazz);
                this.configuration.setVfsImpl(vfsImpl);
            }
        }
    }

    protected void loadCustomLogImpl(Properties props) {
        Class logImpl = this.resolveClass(props.getProperty("logImpl"));
        this.configuration.setLogImpl(logImpl);
    }

    protected void typeAliasesElement(XNode parent) {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                if ("package".equals(child.getName())) {
                    String typeAliasPackage = child.getStringAttribute("name");
                    this.configuration.getTypeAliasRegistry().registerAliases(typeAliasPackage);
                    continue;
                }
                String alias = child.getStringAttribute("alias");
                String type = child.getStringAttribute("type");
                try {
                    Class clazz = Resources.classForName((String)type);
                    if (alias == null) {
                        this.typeAliasRegistry.registerAlias(clazz);
                        continue;
                    }
                    this.typeAliasRegistry.registerAlias(alias, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new BuilderException("Error registering typeAlias for '" + alias + "'. Cause: " + e, (Throwable)e);
                }
            }
        }
    }

    protected void pluginElement(XNode parent) throws Exception {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                String interceptor = child.getStringAttribute("interceptor");
                Properties properties = child.getChildrenAsProperties();
                Interceptor interceptorInstance = (Interceptor)this.resolveClass(interceptor).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                interceptorInstance.setProperties(properties);
                this.configuration.addInterceptor(interceptorInstance);
            }
        }
    }

    protected void objectFactoryElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties properties = context.getChildrenAsProperties();
            ObjectFactory factory = (ObjectFactory)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setProperties(properties);
            this.configuration.setObjectFactory(factory);
        }
    }

    protected void objectWrapperFactoryElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            ObjectWrapperFactory factory = (ObjectWrapperFactory)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.configuration.setObjectWrapperFactory(factory);
        }
    }

    protected void reflectorFactoryElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            ReflectorFactory factory = (ReflectorFactory)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.configuration.setReflectorFactory(factory);
        }
    }

    protected void propertiesElement(XNode context) throws Exception {
        if (context != null) {
            Properties defaults = context.getChildrenAsProperties();
            String resource = context.getStringAttribute("resource");
            String url = context.getStringAttribute("url");
            if (resource != null && url != null) {
                throw new BuilderException("The properties element cannot specify both a URL and a resource based property file reference.  Please specify one or the other.");
            }
            if (resource != null) {
                defaults.putAll((Map<?, ?>)Resources.getResourceAsProperties((String)resource));
            } else if (url != null) {
                defaults.putAll((Map<?, ?>)Resources.getUrlAsProperties((String)url));
            }
            Properties vars = this.configuration.getVariables();
            if (vars != null) {
                defaults.putAll((Map<?, ?>)vars);
            }
            this.parser.setVariables(defaults);
            this.configuration.setVariables(defaults);
        }
    }

    protected void settingsElement(Properties props) {
        this.configuration.setAutoMappingBehavior(AutoMappingBehavior.valueOf((String)props.getProperty("autoMappingBehavior", "PARTIAL")));
        this.configuration.setAutoMappingUnknownColumnBehavior(AutoMappingUnknownColumnBehavior.valueOf((String)props.getProperty("autoMappingUnknownColumnBehavior", "NONE")));
        this.configuration.setCacheEnabled(this.booleanValueOf(props.getProperty("cacheEnabled"), true).booleanValue());
        this.configuration.setProxyFactory((ProxyFactory)this.createInstance(props.getProperty("proxyFactory")));
        this.configuration.setLazyLoadingEnabled(this.booleanValueOf(props.getProperty("lazyLoadingEnabled"), false).booleanValue());
        this.configuration.setAggressiveLazyLoading(this.booleanValueOf(props.getProperty("aggressiveLazyLoading"), false).booleanValue());
        this.configuration.setMultipleResultSetsEnabled(this.booleanValueOf(props.getProperty("multipleResultSetsEnabled"), true).booleanValue());
        this.configuration.setUseColumnLabel(this.booleanValueOf(props.getProperty("useColumnLabel"), true).booleanValue());
        this.configuration.setUseGeneratedKeys(this.booleanValueOf(props.getProperty("useGeneratedKeys"), false).booleanValue());
        this.configuration.setDefaultExecutorType(ExecutorType.valueOf((String)props.getProperty("defaultExecutorType", "SIMPLE")));
        this.configuration.setDefaultStatementTimeout(this.integerValueOf(props.getProperty("defaultStatementTimeout"), null));
        this.configuration.setDefaultFetchSize(this.integerValueOf(props.getProperty("defaultFetchSize"), null));
        this.configuration.setDefaultResultSetType(this.resolveResultSetType(props.getProperty("defaultResultSetType")));
        this.configuration.setMapUnderscoreToCamelCase(this.booleanValueOf(props.getProperty("mapUnderscoreToCamelCase"), false).booleanValue());
        this.configuration.setSafeRowBoundsEnabled(this.booleanValueOf(props.getProperty("safeRowBoundsEnabled"), false).booleanValue());
        this.configuration.setLocalCacheScope(LocalCacheScope.valueOf((String)props.getProperty("localCacheScope", "SESSION")));
        this.configuration.setJdbcTypeForNull(JdbcType.valueOf((String)props.getProperty("jdbcTypeForNull", "OTHER")));
        this.configuration.setLazyLoadTriggerMethods(this.stringSetValueOf(props.getProperty("lazyLoadTriggerMethods"), "equals,clone,hashCode,toString"));
        this.configuration.setSafeResultHandlerEnabled(this.booleanValueOf(props.getProperty("safeResultHandlerEnabled"), true).booleanValue());
        this.configuration.setDefaultScriptingLanguage(this.resolveClass(props.getProperty("defaultScriptingLanguage")));
        this.configuration.setDefaultEnumTypeHandler(this.resolveClass(props.getProperty("defaultEnumTypeHandler")));
        this.configuration.setCallSettersOnNulls(this.booleanValueOf(props.getProperty("callSettersOnNulls"), false).booleanValue());
        this.configuration.setUseActualParamName(this.booleanValueOf(props.getProperty("useActualParamName"), true).booleanValue());
        this.configuration.setReturnInstanceForEmptyRow(this.booleanValueOf(props.getProperty("returnInstanceForEmptyRow"), false).booleanValue());
        this.configuration.setLogPrefix(props.getProperty("logPrefix"));
        this.configuration.setConfigurationFactory(this.resolveClass(props.getProperty("configurationFactory")));
        this.configuration.setShrinkWhitespacesInSql(this.booleanValueOf(props.getProperty("shrinkWhitespacesInSql"), false).booleanValue());
        this.configuration.setDefaultSqlProviderType(this.resolveClass(props.getProperty("defaultSqlProviderType")));
    }

    protected void environmentsElement(XNode context) throws Exception {
        if (context != null) {
            if (this.environment == null) {
                this.environment = context.getStringAttribute("default");
            }
            for (XNode child : context.getChildren()) {
                String id = child.getStringAttribute("id");
                if (!this.isSpecifiedEnvironment(id)) continue;
                TransactionFactory txFactory = this.transactionManagerElement(child.evalNode("transactionManager"));
                DataSourceFactory dsFactory = this.dataSourceElement(child.evalNode("dataSource"));
                DataSource dataSource = dsFactory.getDataSource();
                if (this.dialect == null) {
                    this.dialect = DbUtil.getDialect(dataSource);
                }
                Environment.Builder environmentBuilder = new Environment.Builder(id).transactionFactory(txFactory).dataSource(dataSource);
                this.configuration.setEnvironment(environmentBuilder.build());
                break;
            }
        }
    }

    protected void databaseIdProviderElement(XNode context) throws Exception {
        Environment environment;
        DatabaseIdProvider databaseIdProvider = null;
        if (context != null) {
            String type = context.getStringAttribute("type");
            if ("VENDOR".equals(type)) {
                type = "DB_VENDOR";
            }
            Properties properties = context.getChildrenAsProperties();
            databaseIdProvider = (DatabaseIdProvider)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            databaseIdProvider.setProperties(properties);
        }
        if ((environment = this.configuration.getEnvironment()) != null && databaseIdProvider != null) {
            String databaseId = databaseIdProvider.getDatabaseId(environment.getDataSource());
            this.configuration.setDatabaseId(databaseId);
        }
    }

    protected TransactionFactory transactionManagerElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties props = context.getChildrenAsProperties();
            TransactionFactory factory = (TransactionFactory)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setProperties(props);
            return factory;
        }
        throw new BuilderException("Environment declaration requires a TransactionFactory.");
    }

    protected DataSourceFactory dataSourceElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties props = context.getChildrenAsProperties();
            DataSourceFactory factory = (DataSourceFactory)this.resolveClass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setProperties(props);
            return factory;
        }
        throw new BuilderException("Environment declaration requires a DataSourceFactory.");
    }

    protected void typeHandlerElement(XNode parent) {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                if ("package".equals(child.getName())) {
                    String typeHandlerPackage = child.getStringAttribute("name");
                    this.typeHandlerRegistry.register(typeHandlerPackage);
                    continue;
                }
                String javaTypeName = child.getStringAttribute("javaType");
                String jdbcTypeName = child.getStringAttribute("jdbcType");
                String handlerTypeName = child.getStringAttribute("handler");
                Class javaTypeClass = this.resolveClass(javaTypeName);
                JdbcType jdbcType = this.resolveJdbcType(jdbcTypeName);
                Class typeHandlerClass = this.resolveClass(handlerTypeName);
                if (javaTypeClass != null) {
                    if (jdbcType == null) {
                        this.typeHandlerRegistry.register(javaTypeClass, typeHandlerClass);
                        continue;
                    }
                    this.typeHandlerRegistry.register(javaTypeClass, jdbcType, typeHandlerClass);
                    continue;
                }
                this.typeHandlerRegistry.register(typeHandlerClass);
            }
        }
    }

    protected void mapperElement(XNode parent) throws Exception {
        MyBatisResource[] allMybatisMapperResources;
        Throwable throwable;
        InputStream inputStream;
        ArrayList<String> existResource = new ArrayList<String>(8);
        ArrayList<MyBatisResource> myBatisResources = new ArrayList<MyBatisResource>(16);
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                if ("package".equals(child.getName())) {
                    String mapperPackage = child.getStringAttribute("name");
                    this.configuration.addMappers(mapperPackage);
                    continue;
                }
                String resource = child.getStringAttribute("resource");
                String url = child.getStringAttribute("url");
                String mapperClass = child.getStringAttribute("class");
                if (resource != null && url == null && mapperClass == null) {
                    ErrorContext.instance().resource(resource);
                    existResource.add(resource);
                    MyBatisResource myBatisResource = MyBatisResource.buildFromClasspath(resource);
                    myBatisResources.add(myBatisResource);
                    continue;
                }
                if (resource == null && url != null && mapperClass == null) {
                    ErrorContext.instance().resource(url);
                    inputStream = Resources.getUrlAsStream((String)url);
                    throwable = null;
                    try {
                        XMLMapperBuilder mapperParser = new XMLMapperBuilder(inputStream, this.configuration, url, this.configuration.getSqlFragments());
                        mapperParser.parse();
                        continue;
                    }
                    catch (Throwable mapperParser) {
                        throwable = mapperParser;
                        throw mapperParser;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable mapperParser) {
                                throwable.addSuppressed(mapperParser);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                if (resource == null && url == null && mapperClass != null) {
                    Class mapperInterface = Resources.classForName((String)mapperClass);
                    this.configuration.addMapper(mapperInterface);
                    continue;
                }
                throw new BuilderException("A mapper element may only specify a url, resource or class, but not more than one.");
            }
        }
        this.addNotConfigMapper(existResource, myBatisResources);
        for (MyBatisResource myBatisResource : allMybatisMapperResources = this.mapperLocationsBuilder.build(this.basePackage, myBatisResources, this.dialect)) {
            inputStream = myBatisResource.getInputStream();
            throwable = null;
            try {
                String resource = myBatisResource.getFilepath();
                if (resource == null) {
                    resource = myBatisResource.getFilename();
                }
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(inputStream, this.configuration, resource, this.configuration.getSqlFragments());
                mapperParser.parse();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
    }

    protected void addNotConfigMapper(List<String> existResource, List<MyBatisResource> myBatisResources) throws IOException {
        String[] mapperLocations = this.config.getMapperLocations();
        if (mapperLocations == null || mapperLocations.length == 0) {
            return;
        }
        for (String mapperLocation : mapperLocations) {
            List<IOUtil.ResourceFile> resourceFiles = IOUtil.listJarFiles(mapperLocation, ".xml");
            for (IOUtil.ResourceFile sourceFile : resourceFiles) {
                if (this.containsFile(existResource, sourceFile.getFilename())) continue;
                MyBatisResource myBatisResource = MyBatisResource.buildFromFile(sourceFile.getFilename(), sourceFile.getContent());
                myBatisResources.add(myBatisResource);
            }
        }
    }

    protected boolean containsFile(List<String> existResource, String pathname) {
        for (String existFilename : existResource) {
            if (!pathname.contains(existFilename)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpecifiedEnvironment(String id) {
        if (this.environment == null) {
            throw new BuilderException("No environment specified.");
        }
        if (id == null) {
            throw new BuilderException("Environment requires an id attribute.");
        }
        return this.environment.equals(id);
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setConfig(FastmybatisConfig config) {
        Objects.requireNonNull(config, "FastmybatisConfig can not null");
        this.config = config;
        this.mapperLocationsBuilder.setConfig(config);
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public MapperLocationsBuilder getMapperLocationsBuilder() {
        return this.mapperLocationsBuilder;
    }
}

