/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBuilderExt;
import java.util.Collection;
import java.util.Optional;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlSessionFactoryBuilderContext {
    private final SqlSessionFactoryBuilderExt sqlSessionFactoryBuilderExt;
    private final Configuration configuration;
    private SqlSessionFactory sqlSessionFactory;

    public SqlSessionFactoryBuilderContext(SqlSessionFactoryBuilderExt sqlSessionFactoryBuilderExt, Configuration configuration) {
        this.sqlSessionFactoryBuilderExt = sqlSessionFactoryBuilderExt;
        this.configuration = configuration;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = this.sqlSessionFactoryBuilderExt.build(this.configuration);
            String envId = Optional.ofNullable(this.configuration.getEnvironment()).map(Environment::getId).orElse("default");
            ExtContext.addSqlSessionFactory(envId, this.sqlSessionFactory);
            Collection<Class<?>> mapperClasses = ExtContext.listMapperClass();
            for (Class<?> mapperClass : mapperClasses) {
                ExtContext.addSqlSessionFactory(mapperClass, this.sqlSessionFactory);
            }
        }
        return this.sqlSessionFactory;
    }

    public SqlSessionFactoryBuilderExt getSqlSessionFactoryBuilderExt() {
        return this.sqlSessionFactoryBuilderExt;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

