/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.ibatis.io.Resources;

public class MyBatisResource {
    private String content;
    private String filename;
    private String filepath;
    private boolean merged;
    private boolean exist = true;

    public static MyBatisResource build(String content, Class<?> daoClass) {
        MyBatisResource myBatisResource = new MyBatisResource();
        myBatisResource.setContent(content);
        myBatisResource.setFilename(daoClass.getSimpleName() + ".xml");
        return myBatisResource;
    }

    public static MyBatisResource buildFromClasspath(String classpath) {
        String filename = MyBatisResource.getFilename(classpath);
        MyBatisResource myBatisResource = new MyBatisResource();
        myBatisResource.setFilename(filename);
        myBatisResource.setFilepath(classpath);
        try {
            if (classpath.startsWith("/")) {
                classpath = classpath.substring(1);
            }
            InputStream inputStream = Resources.getResourceAsStream((String)classpath);
            String content = IOUtil.toString(inputStream, StandardCharsets.UTF_8);
            myBatisResource.setContent(content);
        }
        catch (IOException e) {
            myBatisResource.exist = false;
        }
        return myBatisResource;
    }

    public static MyBatisResource buildFromFile(String filename, String content) {
        MyBatisResource myBatisResource = new MyBatisResource();
        myBatisResource.setFilename(filename);
        myBatisResource.setContent(content);
        return myBatisResource;
    }

    public String getContent() {
        return this.content;
    }

    private static String getFilename(String resource) {
        int start = resource.lastIndexOf(47) + 1;
        return resource.substring(start);
    }

    public InputStream getInputStream() {
        return IOUtil.toInputStream(this.content, StandardCharsets.UTF_8);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public boolean exists() {
        return this.exist;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public String toString() {
        return this.filepath == null ? this.filename : this.filepath;
    }
}

