/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.MapperRunner;
import java.util.function.Function;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class Mappers {
    public static <T, R> R run(Class<T> mapperClass, Function<T, R> runner) {
        SqlSessionFactory sqlSessionFactory = ExtContext.getSqlSessionFactoryByMapperClass(mapperClass);
        if (sqlSessionFactory == null) {
            throw new IllegalArgumentException("SqlSessionFactory not found by mapper class:" + mapperClass);
        }
        return Mappers.getMapperRunner(mapperClass).run(runner);
    }

    public static <T> MapperRunner<T> getMapperRunner(Class<T> mapperClass) {
        SqlSessionFactory sqlSessionFactory = ExtContext.getSqlSessionFactoryByMapperClass(mapperClass);
        if (sqlSessionFactory == null) {
            throw new IllegalArgumentException("SqlSessionFactory not found by mapper class:" + mapperClass);
        }
        SqlSession session = sqlSessionFactory.openSession();
        Object mapper = session.getMapper(mapperClass);
        return new MapperRunner<Object>(mapper, session);
    }
}

