/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.util.IOUtil;
import java.util.Optional;
import java.util.function.Function;
import org.apache.ibatis.session.SqlSession;

public class MapperRunner<Mapper> {
    private final Mapper mapper;
    private final Optional<SqlSession> sessionOptional;

    public MapperRunner(Mapper mapper, SqlSession session) {
        this.mapper = mapper;
        this.sessionOptional = Optional.ofNullable(session);
    }

    public <R> R run(Function<Mapper, R> runner) {
        try {
            R ret = runner.apply(this.mapper);
            this.sessionOptional.ifPresent(SqlSession::commit);
            R r = ret;
            return r;
        }
        catch (Throwable e) {
            this.sessionOptional.ifPresent(SqlSession::rollback);
            throw new RuntimeException(e);
        }
        finally {
            this.sessionOptional.ifPresent(xva$0 -> IOUtil.closeQuietly(xva$0));
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Optional<SqlSession> getSessionOptional() {
        return this.sessionOptional;
    }
}

