/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.MyBatisResource;
import com.gitee.fastmybatis.core.ext.code.client.ClassClient;
import com.gitee.fastmybatis.core.ext.exception.GenCodeException;
import com.gitee.fastmybatis.core.ext.exception.MapperFileException;
import com.gitee.fastmybatis.core.ext.spi.ClassSearch;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.util.IOUtil;
import com.gitee.fastmybatis.core.util.MybatisFileUtil;
import com.gitee.fastmybatis.core.util.StringUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class MapperLocationsBuilder {
    private static final Log LOG = LogFactory.getLog(MapperLocationsBuilder.class);
    private final Map<String, MyBatisResource> mybatisMapperStore = new HashMap<String, MyBatisResource>();
    private FastmybatisConfig config;
    private List<String> mapperNames = Collections.emptyList();
    private Set<Class<?>> mapperClasses = new HashSet(64);
    private String dialect;

    public MapperLocationsBuilder() {
        this(new FastmybatisConfig());
    }

    public MapperLocationsBuilder(FastmybatisConfig config) {
        Objects.requireNonNull(config, "config can not null");
        this.config = config;
    }

    public MyBatisResource[] build(Set<Class<?>> mapperClasses, List<MyBatisResource> myBatisResources, String dialect) {
        for (MyBatisResource myBatisResource : myBatisResources) {
            String filename = myBatisResource.getFilename();
            this.mybatisMapperStore.put(filename, myBatisResource);
        }
        this.dialect = dialect;
        try {
            if (this.config.isDisableSqlAnnotation()) {
                this.checkSqlAnnotationOnMapper(mapperClasses);
            }
            MyBatisResource[] myBatisResourceArray = this.buildMapperLocations(mapperClasses);
            return myBatisResourceArray;
        }
        catch (Exception e) {
            LOG.error("\u6784\u5efamapper\u5931\u8d25", (Throwable)e);
            throw new MapperFileException(e);
        }
        finally {
            this.distroy();
        }
    }

    public MyBatisResource[] build(String basePackage, List<MyBatisResource> myBatisResources, String dialect) {
        String[] basePackages = StringUtil.tokenizeToStringArray(basePackage, ",; \t\n");
        ClassSearch classSearch = SpiContext.getClassSearch();
        try {
            Set<Class<?>> clazzsSet = classSearch.search(Object.class, basePackages);
            return this.build(clazzsSet, myBatisResources, dialect);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkSqlAnnotationOnMapper(Set<Class<?>> clazzsSet) {
        if (null == clazzsSet || 0 == clazzsSet.size()) {
            return;
        }
        for (Class<?> mapperClass : clazzsSet) {
            Method[] methods = mapperClass.getMethods();
            if (null == methods || methods.length == 0) continue;
            for (Method m : methods) {
                this.checkInsert(mapperClass, m);
                this.checkDelete(mapperClass, m);
                this.checkSelect(mapperClass, m);
                this.checkUpdate(mapperClass, m);
            }
        }
    }

    private void checkInsert(Class<?> mapperClass, Method m) {
        Insert anno = m.getAnnotation(Insert.class);
        if (null != anno) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u5c06sql\u5199\u5728Mybatis\u6ce8\u89e3\u4e2d.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
        InsertProvider annoSp = m.getAnnotation(InsertProvider.class);
        if (null != annoSp) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u4f7f\u7528InsertProvider\u6ce8\u89e3.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
    }

    private void checkSelect(Class<?> mapperClass, Method m) {
        Select anno = m.getAnnotation(Select.class);
        if (null != anno) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u5c06sql\u5199\u5728Mybatis\u6ce8\u89e3\u4e2d.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
        SelectProvider annoSp = m.getAnnotation(SelectProvider.class);
        if (null != annoSp) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u4f7f\u7528SelectProvider\u6ce8\u89e3.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
    }

    private void checkUpdate(Class<?> mapperClass, Method m) {
        Update anno = m.getAnnotation(Update.class);
        if (null != anno) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u5c06sql\u5199\u5728Mybatis\u6ce8\u89e3\u4e2d.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
        UpdateProvider annoSp = m.getAnnotation(UpdateProvider.class);
        if (null != annoSp) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u4f7f\u7528UpdateProvider\u6ce8\u89e3.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
    }

    private void checkDelete(Class<?> mapperClass, Method m) {
        Delete anno = m.getAnnotation(Delete.class);
        if (null != anno) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u5c06sql\u5199\u5728Mybatis\u6ce8\u89e3\u4e2d.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
        DeleteProvider annoSp = m.getAnnotation(DeleteProvider.class);
        if (null != annoSp) {
            throw new IllegalStateException("\u672c\u9879\u76ee\u7981\u6b62\u4f7f\u7528DeleteProvider\u6ce8\u89e3.\u95ee\u9898Mapper:" + mapperClass.getName() + ",\u95ee\u9898\u65b9\u6cd5\uff1a" + m.getName());
        }
    }

    private void distroy() {
        this.mybatisMapperStore.clear();
    }

    private MyBatisResource getMapperFile(String mapperFileName) {
        return this.mybatisMapperStore.get(mapperFileName);
    }

    private MyBatisResource[] buildMapperLocations(Set<Class<?>> clazzsSet) {
        this.initContext(clazzsSet);
        List<MyBatisResource> mapperLocations = this.buildMapperResource(clazzsSet);
        this.addUnmergedResource(mapperLocations);
        this.addCommonSqlClasspathMapper(mapperLocations);
        return mapperLocations.toArray(new MyBatisResource[mapperLocations.size()]);
    }

    private List<MyBatisResource> buildMapperResource(Set<Class<?>> clazzsSet) {
        int classCount = clazzsSet.size();
        if (classCount == 0) {
            return new ArrayList<MyBatisResource>();
        }
        MyBatisResource templateResource = this.buildTemplateResource(this.getDbName());
        LOG.debug("\u4f7f\u7528\u6a21\u677f:" + templateResource);
        String globalVmLocation = this.config.getGlobalVmLocation();
        ClassClient codeClient = new ClassClient(this.config);
        ArrayList<MyBatisResource> mapperLocations = new ArrayList<MyBatisResource>(classCount);
        long startTime = System.currentTimeMillis();
        try {
            String templateContent = templateResource.getContent();
            for (Class<?> daoClass : clazzsSet) {
                String xml = codeClient.genMybatisXml(daoClass, templateContent, globalVmLocation);
                xml = this.mergeExtMapperFile(daoClass, xml);
                this.saveMapper(daoClass.getSimpleName() + ".xml", xml);
                mapperLocations.add(MyBatisResource.build(xml, daoClass));
            }
            long endTime = System.currentTimeMillis();
            LOG.debug("\u751f\u6210Mapper\u5185\u5bb9\u603b\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2");
            return mapperLocations;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GenCodeException(e);
        }
    }

    private List<String> buildMapperNames(Set<Class<?>> clazzsSet) {
        ArrayList<String> list = new ArrayList<String>(clazzsSet.size());
        for (Class<?> mapperClass : clazzsSet) {
            list.add(mapperClass.getSimpleName());
        }
        return list;
    }

    private void initContext(Set<Class<?>> clazzsSet) {
        this.mapperClasses.addAll(clazzsSet);
        this.mapperNames = this.buildMapperNames(clazzsSet);
        for (Class<?> mapperClass : clazzsSet) {
            ExtContext.addMapperClass(mapperClass);
        }
    }

    public Set<Class<?>> getMapperClasses() {
        return this.mapperClasses;
    }

    private void saveMapper(String filename, String content) throws IOException {
        String saveDir = this.config.getMapperSaveDir();
        if (StringUtil.hasText(saveDir)) {
            String path = saveDir + "/" + filename;
            LOG.debug("\u4fdd\u5b58mapper\u6587\u4ef6\u5230" + path);
            try (FileOutputStream out = new FileOutputStream(path);){
                IOUtil.copy(IOUtil.toInputStream(content, StandardCharsets.UTF_8), out);
            }
        }
    }

    private MyBatisResource buildTemplateResource(String dialect) {
        String templateFileName = this.buildTemplateFileName(dialect);
        MyBatisResource myBatisResource = MyBatisResource.buildFromClasspath(templateFileName);
        if (myBatisResource.exists()) {
            return myBatisResource;
        }
        String templateClasspath = this.config.getTemplateClasspath();
        if (StringUtil.isEmpty(templateClasspath)) {
            templateClasspath = "/fastmybatis/tpl/";
        }
        String location = templateClasspath + templateFileName;
        return MyBatisResource.buildFromClasspath(location);
    }

    private String buildTemplateFileName(String dialect) {
        dialect = dialect.replaceAll("\\s", "").toLowerCase();
        return dialect + ".vm";
    }

    private void addCommonSqlClasspathMapper(List<MyBatisResource> mapperLocations) {
        String commonSqlClasspath = this.config.getCommonSqlClasspath();
        MyBatisResource myBatisResource = MyBatisResource.buildFromClasspath(commonSqlClasspath);
        mapperLocations.add(myBatisResource);
    }

    private void addUnmergedResource(List<MyBatisResource> mapperLocations) {
        Collection<MyBatisResource> mapperResourceDefinitions = this.mybatisMapperStore.values();
        for (MyBatisResource mapperResourceDefinition : mapperResourceDefinitions) {
            if (mapperResourceDefinition.isMerged()) continue;
            LOG.debug("\u52a0\u8f7d\u672a\u5408\u5e76Mapper\uff1a" + mapperResourceDefinition.getFilename());
            mapperLocations.add(mapperResourceDefinition);
        }
    }

    private String mergeExtMapperFile(Class<?> mapperClass, String xml) throws IOException, DocumentException {
        String mapperFileName = mapperClass.getSimpleName() + ".xml";
        MyBatisResource myBatisResource = this.getMapperFile(mapperFileName);
        StringBuilder extXml = new StringBuilder();
        if (myBatisResource != null) {
            String extFileContent = MybatisFileUtil.getExtFileContent(myBatisResource.getInputStream());
            extXml.append(extFileContent);
            myBatisResource.setMerged(true);
        }
        String otherMapperXml = this.buildOtherMapperContent(mapperClass, this.mybatisMapperStore.values());
        extXml.append(otherMapperXml);
        xml = xml.replace("<!--_ext_mapper_-->", extXml.toString());
        return xml;
    }

    private String buildOtherMapperContent(Class<?> mapperClass, Collection<MyBatisResource> mapperResourceDefinitions) throws IOException, DocumentException {
        StringBuilder xml = new StringBuilder();
        String trueNamespace = mapperClass.getName();
        for (MyBatisResource mapperResourceDefinition : mapperResourceDefinitions) {
            String namespaceValue;
            String filename = mapperResourceDefinition.getFilename();
            filename = filename.substring(0, filename.length() - 4);
            if (mapperResourceDefinition.isMerged() || this.mapperNames.contains(filename)) continue;
            InputStream in = mapperResourceDefinition.getInputStream();
            Document document = this.buildSAXReader().read(in);
            Element mapperNode = document.getRootElement();
            Attribute attrNamespace = mapperNode.attribute("namespace");
            String string = namespaceValue = attrNamespace == null ? null : attrNamespace.getValue();
            if (StringUtil.isEmpty(namespaceValue)) {
                throw new MapperFileException("Mapper\u6587\u4ef6[" + mapperResourceDefinition.getFilename() + "]\u7684namespace\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!trueNamespace.equals(namespaceValue)) continue;
            String contentXml = MybatisFileUtil.trimMapperNode(mapperNode);
            xml.append(contentXml);
            mapperResourceDefinition.setMerged(true);
        }
        return xml.toString();
    }

    private SAXReader buildSAXReader() {
        SAXReader reader = new SAXReader();
        reader.setEncoding("UTF-8");
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            LOG.error("reader.setFeature fail by ", (Throwable)e);
        }
        return reader;
    }

    public void setConfig(FastmybatisConfig config) {
        this.config = config;
    }

    public String getDbName() {
        return this.dialect;
    }

    public void setDbName(String dialect) {
        this.dialect = dialect;
    }

    public void setMapperExecutorPoolSize(int poolSize) {
        this.config.setMapperExecutorPoolSize(poolSize);
    }

    public FastmybatisConfig getConfig() {
        return this.config;
    }
}

