/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.util.ClassUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;

public class ExtContext {
    private static final Map<String, Class<?>> entityMapper = new HashMap(16);
    private static final Map<String, SqlSessionFactory> sqlSessionFactoryMapForEnv = new HashMap<String, SqlSessionFactory>();
    private static final Map<String, SqlSessionFactory> sqlSessionFactoryMapForMapper = new HashMap<String, SqlSessionFactory>();

    public static void addMapperClass(Class<?> mapperClass) {
        Class<?> entityClass = ExtContext.getEntityClass(mapperClass);
        entityMapper.put(entityClass.getName(), mapperClass);
    }

    public static Collection<Class<?>> listMapperClass() {
        return entityMapper.values();
    }

    public static Class<?> getMapperClass(Class<?> entityClass) {
        return entityMapper.get(entityClass.getName());
    }

    public static Class<?> getEntityClass(Class<?> mapperClass) {
        if (mapperClass.isInterface()) {
            return ClassUtil.getSuperInterfaceGenericType(mapperClass, 0);
        }
        return ClassUtil.getSuperClassGenricType(mapperClass, 0);
    }

    public static void addSqlSessionFactory(String env, SqlSessionFactory sqlSessionFactory) {
        sqlSessionFactoryMapForEnv.put(env, sqlSessionFactory);
    }

    public static void addSqlSessionFactory(Class<?> mapperClass, SqlSessionFactory sqlSessionFactory) {
        sqlSessionFactoryMapForMapper.put(mapperClass.getName(), sqlSessionFactory);
    }

    public static SqlSessionFactory getSqlSessionFactoryByEnvironment(String environment) {
        return sqlSessionFactoryMapForEnv.get(environment);
    }

    public static SqlSessionFactory getSqlSessionFactoryByMapperClass(Class<?> mapperClass) {
        return sqlSessionFactoryMapForMapper.get(mapperClass.getName());
    }
}

