/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.core.EntityProcessor;
import com.gitee.fastmybatis.core.PageResult;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageSupport<E>
implements PageResult<E> {
    private static final long serialVersionUID = 5931004082164727399L;
    private List<E> list;
    private long total = 0L;
    private int start = 0;
    private int pageIndex = 1;
    private int pageSize = 10;
    private int pageCount = 0;

    public PageResult process(EntityProcessor<E> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor\u4e0d\u80fd\u4e3anull");
        }
        PageSupport pageResult = this;
        List<Object> jsonObjList = PageSupport.processEntityToJSONObject(this.list, processor);
        pageResult.setList(jsonObjList);
        return pageResult;
    }

    public static <E> List<Object> processEntityToJSONObject(List<E> list, EntityProcessor<E> processor) {
        ArrayList<Object> jsonObjList = new ArrayList<Object>(list.size());
        for (E entity : list) {
            Map<String, Object> jsonObject = SpiContext.getBeanExecutor().pojoToMap(entity);
            processor.process(entity, jsonObject);
            jsonObjList.add(jsonObject);
        }
        return jsonObjList;
    }

    protected int fetchCurrentPageIndex() {
        return this.pageIndex;
    }

    protected int fetchPrePageIndex() {
        return this.pageIndex - 1 <= 0 ? 1 : this.pageIndex - 1;
    }

    protected int fetchNextPageIndex() {
        return this.pageIndex + 1 > this.pageCount ? this.pageCount : this.pageIndex + 1;
    }

    protected int fetchFirstPageIndex() {
        return 1;
    }

    protected int fetchLastPageIndex() {
        return this.pageCount;
    }

    protected List<E> fetchList() {
        return this.list;
    }

    protected long fetchTotal() {
        return this.total;
    }

    protected int fetchPageIndex() {
        return this.pageIndex;
    }

    protected int fetchPageSize() {
        return this.pageSize;
    }

    protected int fetchStart() {
        return this.start;
    }

    protected int fetchPageCount() {
        return this.pageCount;
    }

    @Override
    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setList(List<E> list) {
        this.list = list;
    }

    public String toString() {
        return "PageSupport{list=" + this.list + ", total=" + this.total + ", start=" + this.start + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", pageCount=" + this.pageCount + '}';
    }
}

