/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.MapperRunner;
import com.gitee.fastmybatis.core.ext.info.EntityInfo;
import com.gitee.fastmybatis.core.ext.spi.MapperBuilder;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.mapper.CrudMapper;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class FastmybatisContext {
    private static final Log LOG = LogFactory.getLog(FastmybatisContext.class);
    private static final Map<String, EntityInfo> ENTITY_INFO_MAP = new HashMap<String, EntityInfo>(16);
    private static Object applicationContext;

    public static void setApplicationContext(Object applicationContext) {
        FastmybatisContext.applicationContext = applicationContext;
    }

    public static <T extends CrudMapper> MapperRunner<T> getCrudMapperRunner(Class<?> entityClass) {
        Class<?> mapperClass = ExtContext.getMapperClass(entityClass);
        MapperBuilder mapperBuilder = SpiContext.getMapperBuilder();
        return mapperBuilder.getMapperRunner(mapperClass, applicationContext);
    }

    public static EntityInfo getEntityInfo(Class<?> entityClass) {
        return ENTITY_INFO_MAP.get(entityClass.getName());
    }

    public static void setEntityInfo(Class<?> entityClass, EntityInfo entityInfo) {
        ENTITY_INFO_MAP.put(entityClass.getName(), entityInfo);
    }

    public static String getPkColumnName(Class<?> entityClass) {
        EntityInfo entityInfo = FastmybatisContext.getEntityInfo(entityClass);
        if (entityInfo == null) {
            return null;
        }
        return entityInfo.getPkColumnName();
    }

    public static String getPkJavaName(Class<?> entityClass) {
        EntityInfo entityInfo = FastmybatisContext.getEntityInfo(entityClass);
        if (entityInfo == null) {
            return null;
        }
        return entityInfo.getPkJavaName();
    }

    public static Object getPkValue(Object entity) {
        String pkJavaName;
        if (entity == null) {
            return null;
        }
        Class<?> entityClass = entity.getClass();
        Field field = ClassUtil.findField(entityClass, pkJavaName = FastmybatisContext.getPkJavaName(entityClass));
        if (field == null) {
            return null;
        }
        ClassUtil.makeAccessible(field);
        try {
            return field.get(entity);
        }
        catch (IllegalAccessException e) {
            LOG.error("\u53cd\u5c04\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

