/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.annotation.LogicDeleteStrategy;
import com.gitee.fastmybatis.core.handler.BaseFill;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FastmybatisConfig {
    public static final String COUNT_EXPRESSION = "count(*)";
    private static final String GLOBAL_VM_PLACEHOLDER = "<!--_global_vm_-->";
    public static volatile boolean ignoreEmptyString = true;
    public static volatile boolean emptyStringWithTrim = true;
    public static volatile boolean PRINT_SQL;
    public static volatile List<String> defaultIgnoreUpdateColumns;
    private boolean disableSqlAnnotation = false;
    private String[] mapperLocations;
    private boolean camel2underline = Boolean.TRUE;
    private int mapperExecutorPoolSize = 5;
    private String templateClasspath;
    private String commonSqlClasspath = "fastmybatis/commonSql.xml";
    private String mapperSaveDir;
    private String countExpression = "count(*)";
    private String globalVmLocation;
    private String logicDeleteStrategy = LogicDeleteStrategy.FIXED_VALUE.getCode();
    private String logicNotDeleteValue = "0";
    private String logicDeleteValue = "1";
    private List<BaseFill<?>> fillList = new ArrayList(8);
    private boolean hotDeploy;
    private boolean ignoreLogicDeleteWithAssociation;
    private String globalIdName = "id";
    private boolean globalIdIncrement = true;
    private boolean printSql;
    private List<String> ignoreUpdateColumns = new ArrayList<String>(8);

    public FastmybatisConfig() {
        this.ignoreUpdateColumns.addAll(defaultIgnoreUpdateColumns);
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public String getGlobalVmPlaceholder() {
        return GLOBAL_VM_PLACEHOLDER;
    }

    public void setCamel2underline(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public boolean isCamel2underline() {
        return this.camel2underline;
    }

    public String getLogicDeleteStrategy() {
        return this.logicDeleteStrategy;
    }

    public void setLogicDeleteStrategy(String logicDeleteStrategy) {
        this.logicDeleteStrategy = logicDeleteStrategy;
    }

    public int getMapperExecutorPoolSize() {
        return this.mapperExecutorPoolSize;
    }

    public void setMapperExecutorPoolSize(int mapperExecutorPoolSize) {
        if (mapperExecutorPoolSize <= 0) {
            throw new IllegalArgumentException("mapperExecutorPoolSize\u5fc5\u987b\u5927\u4e8e0");
        }
        this.mapperExecutorPoolSize = mapperExecutorPoolSize;
    }

    public String getTemplateClasspath() {
        return this.templateClasspath;
    }

    public void setTemplateClasspath(String templateClasspath) {
        this.templateClasspath = templateClasspath;
    }

    public String getCommonSqlClasspath() {
        return this.commonSqlClasspath;
    }

    public void setCommonSqlClasspath(String commonSqlClasspath) {
        this.commonSqlClasspath = commonSqlClasspath;
    }

    public String getMapperSaveDir() {
        return this.mapperSaveDir;
    }

    public void setMapperSaveDir(String mapperSaveDir) {
        File dir = new File(mapperSaveDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("\u521b\u5efaMapper\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + mapperSaveDir);
        }
        this.mapperSaveDir = mapperSaveDir;
    }

    public <T extends BaseFill<?>> void setFills(List<T> fills) {
        for (BaseFill fill : fills) {
            fill.setFastmybatisConfig(this);
            this.fillList.add(fill);
        }
        this.fillList.sort(Comparator.comparingInt(BaseFill::getOrder));
    }

    public BaseFill<?> getFill(Class<?> entityClass, Field field, String columnName) {
        for (BaseFill<?> fillHandler : this.fillList) {
            if (!fillHandler.match(entityClass, field, columnName)) continue;
            return fillHandler;
        }
        return null;
    }

    public void setCountExpression(String countExpression) {
        this.countExpression = countExpression;
    }

    public String getCountExpression() {
        return this.countExpression;
    }

    public String getGlobalVmLocation() {
        return this.globalVmLocation;
    }

    public void setGlobalVmLocation(String globalVmLocation) {
        this.globalVmLocation = globalVmLocation;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public void setHotDeploy(boolean hotDeploy) {
        this.hotDeploy = hotDeploy;
    }

    public List<String> getIgnoreUpdateColumns() {
        return this.ignoreUpdateColumns;
    }

    public void setIgnoreUpdateColumns(List<String> ignoreUpdateColumns) {
        this.ignoreUpdateColumns = ignoreUpdateColumns;
    }

    public boolean getIgnoreLogicDeleteWithAssociation() {
        return this.ignoreLogicDeleteWithAssociation;
    }

    public void setIgnoreLogicDeleteWithAssociation(boolean ignoreLogicDeleteWithAssociation) {
        this.ignoreLogicDeleteWithAssociation = ignoreLogicDeleteWithAssociation;
    }

    public String getGlobalIdName() {
        return this.globalIdName;
    }

    public void setGlobalIdName(String globalIdName) {
        this.globalIdName = globalIdName;
    }

    public boolean isGlobalIdIncrement() {
        return this.globalIdIncrement;
    }

    public void setGlobalIdIncrement(boolean globalIdIncrement) {
        this.globalIdIncrement = globalIdIncrement;
    }

    public boolean isDisableSqlAnnotation() {
        return this.disableSqlAnnotation;
    }

    public void setDisableSqlAnnotation(boolean disableSqlAnnotation) {
        this.disableSqlAnnotation = disableSqlAnnotation;
    }

    public boolean isPrintSql() {
        return this.printSql;
    }

    public void setPrintSql(boolean printSql) {
        this.printSql = printSql;
    }

    static {
        defaultIgnoreUpdateColumns = Collections.emptyList();
    }
}

