/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBuilderContext;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBuilderExt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.SqlSessionFactory;

public class Fastmybatis {
    protected SqlSessionFactory sqlSessionFactory;
    protected String configLocation;
    protected String[] mapperLocations;
    protected String basePackage;
    protected Environment environment;
    protected String environmentId;
    protected Properties properties;
    protected FastmybatisConfig config = new FastmybatisConfig();
    protected String dialect;

    public static Fastmybatis create() {
        return new Fastmybatis();
    }

    public Fastmybatis mapperLocations(String ... mapperLocations) {
        this.mapperLocations = mapperLocations;
        return this;
    }

    public Fastmybatis configLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public Fastmybatis basePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public Fastmybatis config(FastmybatisConfig config) {
        this.config = config;
        return this;
    }

    public Fastmybatis environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public Fastmybatis environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public Fastmybatis properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Fastmybatis dialect(String dialect) {
        this.dialect = Objects.requireNonNull(dialect);
        return this;
    }

    public Fastmybatis load() {
        Objects.requireNonNull(this.configLocation);
        Objects.requireNonNull(this.basePackage);
        Objects.requireNonNull(this.config);
        this.config.setMapperLocations(this.mapperLocations);
        try {
            InputStream inputStream = Resources.getResourceAsStream((String)this.configLocation);
            SqlSessionFactoryBuilderExt sqlSessionFactoryBuilderExt = new SqlSessionFactoryBuilderExt(this.basePackage, this.config, this.dialect, this.environment);
            SqlSessionFactoryBuilderContext sqlSessionFactoryBuilderContext = sqlSessionFactoryBuilderExt.buildSqlSessionFactoryBuilderContext(inputStream, this.environmentId, this.properties);
            this.sqlSessionFactory = sqlSessionFactoryBuilderContext.getSqlSessionFactory();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521d\u59cb\u5316mybatis\u5931\u8d25", e);
        }
        return this;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public String toString() {
        return "Fastmybatis{configLocation='" + this.configLocation + '\'' + ", mapperLocations=" + Arrays.toString(this.mapperLocations) + ", basePackage='" + this.basePackage + '\'' + '}';
    }
}

