/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.spring.boot.autoconfigure;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.interceptor.ApiInterceptor;
import com.gitee.easyopen.spring.boot.autoconfigure.EasyopenProperties;
import com.gitee.easyopen.support.ApiController;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={EasyopenProperties.class})
public class EasyopenAutoConfiguration {
    private final EasyopenProperties properties;

    public EasyopenAutoConfiguration(EasyopenProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiConfig apiConfig() {
        return new ApiConfig();
    }

    @Bean
    @ConditionalOnProperty(prefix="easyopen", name={"cors"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnMissingBean
    public CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        return corsConfiguration;
    }

    @Controller
    @RequestMapping(value={"api"})
    public class EayopenIndexController
    extends ApiController {
        @Autowired
        private ApiConfig config;

        protected void initApiConfig(ApiConfig apiConfig) {
            BeanUtils.copyProperties((Object)EasyopenAutoConfiguration.this.properties, (Object)apiConfig);
            this.config.addAppSecret(EasyopenAutoConfiguration.this.properties.getAppSecret());
            this.initInterceptor(EasyopenAutoConfiguration.this.properties, apiConfig);
        }

        private void initInterceptor(EasyopenProperties properties, ApiConfig apiConfig) {
            if (!CollectionUtils.isEmpty(properties.getInterceptors())) {
                List<String> interceptors = properties.getInterceptors();
                ApiInterceptor[] apiInterceptor = new ApiInterceptor[interceptors.size()];
                for (int i = 0; i < interceptors.size(); ++i) {
                    String interceptorClassName = interceptors.get(i);
                    try {
                        apiInterceptor[i] = (ApiInterceptor)Class.forName(interceptorClassName).newInstance();
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error("Class.forName({}).newInstance() error", (Object)interceptorClassName, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                apiConfig.setInterceptors(apiInterceptor);
            }
        }

        protected ApiConfig newApiConfig() {
            return this.config;
        }
    }
}

