/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.util;

import java.util.Collections;
import java.util.List;
import net.oschina.durcframework.easymybatis.PageInfo;
import net.oschina.durcframework.easymybatis.PageResult;
import net.oschina.durcframework.easymybatis.dao.SchDao;
import net.oschina.durcframework.easymybatis.query.Query;
import net.oschina.durcframework.easymybatis.query.param.BaseParam;

public class QueryUtils {
    private static int calcPageCount(long total, int pageSize) {
        return (int)(pageSize == 0 ? 1L : (total + (long)pageSize - 1L) / (long)pageSize);
    }

    public static <Entity> PageInfo<Entity> query(SchDao<Entity> schDao, BaseParam searchParam) {
        return QueryUtils.query(schDao, Query.build(searchParam), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchDao<Entity> schDao, Query query) {
        return QueryUtils.query(schDao, query, PageInfo.class);
    }

    public static <Entity, T extends PageResult<Entity>> T query(SchDao<Entity> schDao, Query query, Class<T> pageResultClass) {
        PageResult result = null;
        try {
            result = (PageResult)pageResultClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            long total = 0L;
            int start = query.getStart();
            int pageSize = query.getLimit();
            int pageIndex = start / pageSize + 1;
            List<Object> list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = schDao.find(query);
                total = list.size();
            } else {
                total = schDao.countTotal(query);
                if (total > 0L) {
                    list = schDao.find(query);
                }
            }
            result.setList(list);
            result.setTotal(total);
            result.setStart(start);
            result.setPageIndex(pageIndex);
            result.setPageSize(pageSize);
            int pageCount = QueryUtils.calcPageCount(total, pageSize);
            result.setPageCount(pageCount);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }
}

