/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassUtil {
    private static final String PREFIX_GET = "get";
    private static String classPath = ClassUtil.class.getClassLoader().getResource("").getPath();

    private ClassUtil() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperInterfaceGenricType(Class<?> clazz, int index) {
        Type[] interfacesTypes = clazz.getGenericInterfaces();
        if (interfacesTypes.length == 0) {
            return Object.class;
        }
        Type firstInterface = interfacesTypes[0];
        Type[] params = ((ParameterizedType)firstInterface).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static String getClassRootPath() {
        return classPath;
    }

    public static String getClassSimpleName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public static Map<String, Object> convertObj2Map(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        Method[] methods = obj.getClass().getDeclaredMethods();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodName.startsWith(PREFIX_GET)) continue;
                String fieldName = ClassUtil.buildFieldName(methodName);
                Object value = method.invoke(obj, new Object[0]);
                map.put(fieldName, value);
            }
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
        return map;
    }

    private static String buildFieldName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }
}

