/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.support;

import java.util.List;
import java.util.Map;
import net.oschina.durcframework.easymybatis.PageResult;
import net.oschina.durcframework.easymybatis.dao.CrudDao;
import net.oschina.durcframework.easymybatis.query.Column;
import net.oschina.durcframework.easymybatis.query.Query;
import net.oschina.durcframework.easymybatis.query.Queryable;
import net.oschina.durcframework.easymybatis.query.expression.Expressional;
import net.oschina.durcframework.easymybatis.support.Updater;
import net.oschina.durcframework.easymybatis.support.lock.DefaultRecordLock;
import net.oschina.durcframework.easymybatis.support.lock.RecordLock;
import net.oschina.durcframework.easymybatis.util.MyBeanUtil;
import net.oschina.durcframework.easymybatis.util.QueryUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CrudService<Dao extends CrudDao<Entity>, Entity> {
    private Dao dao;
    private static RecordLock DEFAULT_RECORD_LOCK = new DefaultRecordLock();

    public Dao getDao() {
        return this.dao;
    }

    @Autowired
    public void setDao(Dao dao) {
        this.dao = dao;
    }

    protected RecordLock getLock(Entity entity) {
        return DEFAULT_RECORD_LOCK;
    }

    public PageResult<Entity> query(Query query) {
        return QueryUtils.query(this.dao, query);
    }

    public <T extends PageResult<Entity>> T query(Query query, Class<T> resultClass) {
        return QueryUtils.query(this.dao, query, resultClass);
    }

    public int update(Entity entity) {
        return this.lockUpdate(new Updater<Entity>(){

            @Override
            public int doUpdate(Entity entity) {
                return CrudService.this.getDao().update(entity);
            }
        }, entity);
    }

    public int updateIgnoreNull(Entity entity) {
        return this.lockUpdate(new Updater<Entity>(){

            @Override
            public int doUpdate(Entity entity) {
                return CrudService.this.getDao().updateIgnoreNull(entity);
            }
        }, entity);
    }

    public int updateIgnoreNullByExpression(Entity entity, final Expressional expressional) {
        return this.lockUpdate(new Updater<Entity>(){

            @Override
            public int doUpdate(Entity entity) {
                return CrudService.this.getDao().updateIgnoreNullByExpression(entity, expressional);
            }
        }, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lockUpdate(Updater<Entity> updater, Entity entity) {
        RecordLock recordLock = this.getLock(entity);
        recordLock.lock(entity);
        int i = 0;
        try {
            Entity obj = this.get(entity);
            this.copyProperties(entity, obj);
            i = updater.doUpdate(obj);
        }
        finally {
            recordLock.unlock(entity);
        }
        return i;
    }

    public void copyProperties(Object source, Entity target) {
        MyBeanUtil.copyProperties(source, target);
    }

    public Entity get(Object id) {
        return this.getDao().get(id);
    }

    public Entity getByExpression(Queryable Queryable2) {
        return this.getDao().getByExpression(Queryable2);
    }

    public Entity getByProperty(String column, Object value) {
        return this.getDao().getByProperty(column, value);
    }

    public List<Entity> listByProperty(String column, Object value) {
        return this.getDao().listByProperty(column, value);
    }

    public List<Entity> listByProperty(String column, Object value, Queryable Queryable2) {
        return this.getDao().listByProperty(column, value, Queryable2);
    }

    public List<Entity> find(Queryable Queryable2) {
        return this.getDao().find(Queryable2);
    }

    public long countTotal(Queryable Queryable2) {
        return this.getDao().countTotal(Queryable2);
    }

    public List<Map<String, Object>> findProjection(Queryable Queryable2) {
        return this.getDao().findProjection(Queryable2);
    }

    public int save(Entity entity) {
        return this.getDao().save(entity);
    }

    public int saveIgnoreNull(Entity entity) {
        return this.getDao().saveIgnoreNull(entity);
    }

    public int saveBatch(List<Entity> entitys) {
        return this.getDao().saveBatch(entitys);
    }

    public int saveBatchWithColumns(List<Column> columns, List<Entity> entitys) {
        return this.getDao().saveBatchWithColumns(columns, entitys);
    }

    public int saveMulti(List<Entity> entitys) {
        return this.getDao().saveMulti(entitys);
    }

    public int saveMultiWithColumns(List<Column> columns, List<Entity> entitys) {
        return this.getDao().saveMultiWithColumns(columns, entitys);
    }

    public int del(Entity entity) {
        return this.getDao().del(entity);
    }

    public int delByExpression(Queryable query) {
        return this.getDao().delByExpression(query);
    }
}

