/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.query.expression.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oschina.durcframework.easymybatis.query.annotation.LikeDoubleField;
import net.oschina.durcframework.easymybatis.query.annotation.LikeLeftField;
import net.oschina.durcframework.easymybatis.query.annotation.LikeRightField;
import net.oschina.durcframework.easymybatis.query.annotation.ListField;
import net.oschina.durcframework.easymybatis.query.annotation.ValueField;
import net.oschina.durcframework.easymybatis.query.expression.Expression;
import net.oschina.durcframework.easymybatis.query.expression.builder.ExpressionGetter;
import net.oschina.durcframework.easymybatis.query.expression.builder.LikeDoubleExpressionGetter;
import net.oschina.durcframework.easymybatis.query.expression.builder.LikeLeftExpressionGetter;
import net.oschina.durcframework.easymybatis.query.expression.builder.LikeRightExpressionGetter;
import net.oschina.durcframework.easymybatis.query.expression.builder.ListExpressionGetter;
import net.oschina.durcframework.easymybatis.query.expression.builder.ValueExpressionGetter;

public class QueryBuilder {
    private static final String PREFIX_GET = "get";

    public static List<Expression> buildExpressions(Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<Expression> expList = new ArrayList<Expression>();
        Method[] methods = obj.getClass().getDeclaredMethods();
        try {
            for (Method method : methods) {
                Annotation[] annotations;
                String methodName = method.getName();
                if (!QueryBuilder.couldBuildExpression(methodName, annotations = method.getAnnotations())) continue;
                Object value = method.invoke(obj, new Object[0]);
                expList.addAll(QueryBuilder.buildExpression(annotations, value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return expList;
    }

    private static List<Expression> buildExpression(Annotation[] annotations, Object value) {
        ArrayList<Expression> expList = new ArrayList<Expression>();
        for (Annotation annotation : annotations) {
            ExpressionGetter expressionGetter = AnnoExprStore.get(annotation);
            Expression expression = expressionGetter.buildExpression(annotation, value);
            if (expression == null) continue;
            expList.add(expression);
        }
        return expList;
    }

    private static boolean couldBuildExpression(String methodName, Annotation[] annotations) {
        return methodName.startsWith(PREFIX_GET) && QueryBuilder.hasExpressionAnnotation(annotations);
    }

    private static boolean hasExpressionAnnotation(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (AnnoExprStore.get(annotation) == null) continue;
            return true;
        }
        return false;
    }

    static {
        AnnoExprStore.addExpressionGetter(ListField.class, new ListExpressionGetter());
        AnnoExprStore.addExpressionGetter(ValueField.class, new ValueExpressionGetter());
        AnnoExprStore.addExpressionGetter(LikeLeftField.class, new LikeLeftExpressionGetter());
        AnnoExprStore.addExpressionGetter(LikeRightField.class, new LikeRightExpressionGetter());
        AnnoExprStore.addExpressionGetter(LikeDoubleField.class, new LikeDoubleExpressionGetter());
    }

    static class AnnoExprStore {
        private static Map<String, ExpressionGetter> map = new HashMap<String, ExpressionGetter>();

        AnnoExprStore() {
        }

        public static ExpressionGetter get(Annotation annotation) {
            return map.get(annotation.annotationType().getSimpleName());
        }

        public static void addExpressionGetter(Class<?> clazz, ExpressionGetter getter) {
            map.put(clazz.getSimpleName(), getter);
        }
    }
}

