/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.query.expression;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.oschina.durcframework.easymybatis.query.expression.ExpressionListable;
import net.oschina.durcframework.easymybatis.query.expression.ValueConvert;

public class ListExpression
implements ExpressionListable {
    private String column = "";
    private String equal = "IN";
    private Collection<?> value = Collections.EMPTY_LIST;
    private String joint = "AND";

    public ListExpression(String column, Collection<?> value) {
        this.column = column;
        this.value = value;
    }

    public ListExpression(String column, String equal, Collection<?> value, ValueConvert valueConvert) {
        this(column, value, valueConvert);
        this.equal = equal;
    }

    public ListExpression(String column, Collection<?> value, ValueConvert valueConvert) {
        if (valueConvert == null) {
            throw new NullPointerException("\u53c2\u6570ValueConvert\u4e0d\u80fd\u4e3anull");
        }
        this.column = column;
        HashSet newSet = new HashSet();
        for (Object obj : value) {
            newSet.add(valueConvert.convert(obj));
        }
        this.value = newSet;
    }

    public ListExpression(String column, Object[] value) {
        this.column = column;
        this.value = Arrays.asList(value);
    }

    public ListExpression(String column, String equal, Object[] value) {
        this(column, value);
        this.equal = equal;
    }

    public ListExpression(String joint, String column, String equal, Object[] value) {
        this(column, equal, value);
        this.joint = joint;
    }

    public ListExpression(String column, String equal, Collection<?> value) {
        this(column, value);
        this.equal = equal;
    }

    public ListExpression(String joint, String column, String equal, Collection<?> value) {
        this(column, equal, value);
        this.joint = joint;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public String getEqual() {
        return this.equal;
    }

    public void setEqual(String equal) {
        this.equal = equal;
    }

    @Override
    public Collection<?> getValue() {
        return this.value;
    }

    public void setValue(Collection<?> value) {
        this.value = value;
    }

    @Override
    public String getJoint() {
        return this.joint;
    }

    public void setJoint(String joint) {
        this.joint = joint;
    }
}

