/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.oschina.durcframework.easymybatis.query.Queryable;
import net.oschina.durcframework.easymybatis.query.Sort;
import net.oschina.durcframework.easymybatis.query.expression.Expression;
import net.oschina.durcframework.easymybatis.query.expression.ExpressionJoinable;
import net.oschina.durcframework.easymybatis.query.expression.ExpressionListable;
import net.oschina.durcframework.easymybatis.query.expression.ExpressionSqlable;
import net.oschina.durcframework.easymybatis.query.expression.ExpressionValueable;
import net.oschina.durcframework.easymybatis.query.expression.Expressional;
import net.oschina.durcframework.easymybatis.query.expression.JoinExpression;
import net.oschina.durcframework.easymybatis.query.expression.ListExpression;
import net.oschina.durcframework.easymybatis.query.expression.SqlExpression;
import net.oschina.durcframework.easymybatis.query.expression.ValueConvert;
import net.oschina.durcframework.easymybatis.query.expression.ValueExpression;
import net.oschina.durcframework.easymybatis.query.expression.builder.QueryBuilder;
import net.oschina.durcframework.easymybatis.query.param.BaseParam;
import net.oschina.durcframework.easymybatis.query.param.SchPageableParam;
import net.oschina.durcframework.easymybatis.query.param.SchSortableParam;

public class Query
implements Queryable {
    private static final String REG_SQL_INJECT = "([';*--|])+";
    private int start;
    private int limit = 10;
    private Set<String> orderInfo;
    private boolean queryAll;
    private Map<String, Object> paramMap;
    private List<ExpressionValueable> valueExpressions;
    private List<ExpressionJoinable> joinExpressions;
    private List<ExpressionListable> listExpressions;
    private List<ExpressionSqlable> sqlExpressions;
    private List<String> columns = Collections.emptyList();
    private List<String> otherTableColumns;

    public static Query build() {
        return new Query();
    }

    public Query addOtherColumn(String column) {
        if (this.otherTableColumns == null) {
            this.otherTableColumns = new ArrayList<String>();
        }
        this.otherTableColumns.add(column);
        return this;
    }

    public Query addOtherColumns(String ... columns) {
        for (String column : columns) {
            this.addOtherColumn(column);
        }
        return this;
    }

    @Override
    public List<String> getOtherTableColumns() {
        return this.otherTableColumns;
    }

    public Query setStart(int start) {
        this.start = start;
        return this;
    }

    public Query setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query setPage(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        this.setStart((pageIndex - 1) * pageSize);
        this.setLimit(pageSize);
        return this;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public int getFirstResult() {
        return this.getStart();
    }

    public int getPageSize() {
        return this.getLimit();
    }

    public static Query buildQueryAll() {
        Query query = new Query();
        query.queryAll = true;
        return query;
    }

    public Query addAnnotionExpression(Object searchEntity) {
        List<Expression> expresList = QueryBuilder.buildExpressions(searchEntity);
        for (Expression expression : expresList) {
            this.addExpression(expression);
        }
        return this;
    }

    public Query addPaginationInfo(SchPageableParam searchEntity) {
        this.start = searchEntity.getStart();
        this.limit = searchEntity.getLimit();
        return this;
    }

    public Query addSortInfo(SchSortableParam searchEntity) {
        this.addSort(searchEntity.getDBSortname(), searchEntity.getSortorder());
        return this;
    }

    public static Query build(BaseParam searchEntity) {
        return searchEntity.toQuery();
    }

    @Override
    public Expressional addExpression(Expression expression) {
        if (expression instanceof ExpressionValueable) {
            if (this.valueExpressions == null) {
                this.valueExpressions = new ArrayList<ExpressionValueable>();
            }
            this.valueExpressions.add((ExpressionValueable)expression);
        } else if (expression instanceof ExpressionListable) {
            if (this.listExpressions == null) {
                this.listExpressions = new ArrayList<ExpressionListable>();
            }
            this.listExpressions.add((ExpressionListable)expression);
        } else if (expression instanceof ExpressionJoinable) {
            if (this.joinExpressions == null) {
                this.joinExpressions = new ArrayList<ExpressionJoinable>();
            }
            this.joinExpressions.add((ExpressionJoinable)expression);
        } else if (expression instanceof ExpressionSqlable) {
            if (this.sqlExpressions == null) {
                this.sqlExpressions = new ArrayList<ExpressionSqlable>();
            }
            this.sqlExpressions.add((ExpressionSqlable)expression);
        }
        return this;
    }

    public void addAll(List<Expression> expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                this.addExpression(expression);
            }
        }
    }

    public Query addParam(String name, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, Object>();
        }
        this.paramMap.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getParam() {
        return this.paramMap;
    }

    @Override
    public boolean getIsQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(boolean queryAll) {
        this.queryAll = queryAll;
    }

    @Override
    public List<ExpressionValueable> getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public List<ExpressionJoinable> getJoinExpressions() {
        return this.joinExpressions;
    }

    @Override
    public List<ExpressionListable> getListExpressions() {
        return this.listExpressions;
    }

    @Override
    public List<ExpressionSqlable> getSqlExpressions() {
        return this.sqlExpressions;
    }

    public Query addSort(String sortname) {
        return this.addSort(sortname, "ASC");
    }

    public Query addSort(String sortname, Sort sort) {
        return this.addSort(sortname, sort.name());
    }

    @Deprecated
    public Query addSort(String sortname, String sortorder) {
        if (sortname != null && sortname.length() > 0) {
            if (this.orderInfo == null) {
                this.orderInfo = new LinkedHashSet<String>();
            }
            sortname = sortname.replace(REG_SQL_INJECT, "");
            if (!"DESC".equalsIgnoreCase(sortorder)) {
                sortorder = "ASC";
            }
            this.orderInfo.add(sortname + " " + sortorder);
        }
        return this;
    }

    @Override
    public boolean getOrderable() {
        return this.orderInfo != null;
    }

    @Override
    public String getOrder() {
        if (this.orderInfo == null) {
            throw new NullPointerException("orderInfo\u4e3a\u7a7a,\u5fc5\u987b\u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5.");
        }
        StringBuilder sb = new StringBuilder();
        for (String order : this.orderInfo) {
            sb.append(",").append(order);
        }
        if (sb.length() > 0) {
            return sb.toString().substring(1);
        }
        return "";
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public Query join(String joinSql) {
        this.addExpression(new JoinExpression(joinSql));
        return this;
    }

    public Query allEq(LinkedHashMap<String, Object> map) {
        Set<String> keys = map.keySet();
        for (String columnName : keys) {
            this.eq(columnName, map.get(columnName));
        }
        return this;
    }

    public Query eq(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, value));
        return this;
    }

    public Query notEq(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, "<>", value));
        return this;
    }

    public Query gt(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, ">", value));
        return this;
    }

    public Query ge(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, ">=", value));
        return this;
    }

    public Query lt(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, "<", value));
        return this;
    }

    public Query le(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, "<=", value));
        return this;
    }

    public Query like(String columnName, Object value) {
        this.addExpression(new ValueExpression(columnName, "LIKE", value));
        return this;
    }

    public Query in(String columnName, Collection<?> value) {
        return this.in(columnName, value, null);
    }

    public Query in(String columnName, Collection<?> value, ValueConvert valueConvert) {
        if (value == null || value.size() == 0) {
            return this.notEq();
        }
        ListExpression expression = valueConvert == null ? new ListExpression(columnName, value) : new ListExpression(columnName, value, valueConvert);
        this.addExpression(expression);
        return this;
    }

    public Query in(String columnName, Object[] value) {
        if (value == null || value.length == 0) {
            return this.notEq();
        }
        this.addExpression(new ListExpression(columnName, value));
        return this;
    }

    public Query notIn(String columnName, Collection<?> value) {
        this.addExpression(new ListExpression(columnName, "NOT IN", value));
        return this;
    }

    public Query notIn(String columnName, Collection<?> value, ValueConvert valueConvert) {
        this.addExpression(new ListExpression(columnName, "NOT IN", value, valueConvert));
        return this;
    }

    public Query notIn(String columnName, Object[] value) {
        this.addExpression(new ListExpression(columnName, "NOT IN", value));
        return this;
    }

    public Query sql(String sql) {
        this.addExpression(new SqlExpression(sql));
        return this;
    }

    public Query notNull(String column) {
        return this.sql(column + " IS NOT NULL");
    }

    public Query isNull(String column) {
        return this.sql(column + " IS NULL");
    }

    public Query notEmpty(String column) {
        return this.sql(column + " IS NOT NULL AND " + column + " <> '' ");
    }

    public Query isEmpty(String column) {
        return this.sql(column + " IS NULL OR " + column + " = '' ");
    }

    public Query notEq() {
        return this.sql("1=2");
    }
}

