/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.handler;

import net.oschina.durcframework.easymybatis.handler.BaseEnum;
import net.oschina.durcframework.easymybatis.handler.TypeHandlerAdapter;

public class EnumTypeHandler<E extends Enum<?>>
extends TypeHandlerAdapter<E> {
    private Class<E> clazz;

    public EnumTypeHandler(Class<E> enumType) {
        if (enumType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.clazz = enumType;
    }

    @Override
    protected Object getFillValue(E defaultValue) {
        return ((BaseEnum)defaultValue).getCode();
    }

    @Override
    protected E convertValue(Object columnValue) {
        Enum[] enumConstants;
        if (columnValue == null) {
            return null;
        }
        for (Enum e : enumConstants = (Enum[])this.clazz.getEnumConstants()) {
            if (!((BaseEnum)((Object)e)).getCode().toString().equals(columnValue.toString())) continue;
            return (E)e;
        }
        return null;
    }
}

