/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        method.setAccessible(true);
        try {
            if (null != method) {
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fields = null;
        while (clazz != Object.class) {
            try {
                fields = clazz.getDeclaredFields();
                int size = fields.length;
                for (int i = 0; i < size; ++i) {
                    fieldList.add(fields[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

