/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.generator;

import javax.persistence.Table;
import net.oschina.durcframework.easymybatis.EasymybatisConfig;
import net.oschina.durcframework.easymybatis.ext.code.generator.ColumnSelector;
import net.oschina.durcframework.easymybatis.ext.code.generator.TableDefinition;
import net.oschina.durcframework.easymybatis.ext.code.util.FieldUtil;

public class TableSelector {
    private ColumnSelector columnSelector;
    private Class<?> entityClass;
    private EasymybatisConfig config;

    public TableSelector(Class<?> entityClass, EasymybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("EasymybatisConfig\u4e0d\u80fd\u4e3anull");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass\u4e0d\u80fd\u4e3anull");
        }
        this.entityClass = entityClass;
        this.config = config;
        this.columnSelector = new ColumnSelector(entityClass, config);
    }

    public TableDefinition getTableDefinition() {
        TableDefinition tableDefinition = new TableDefinition();
        Table tableAnno = this.entityClass.getAnnotation(Table.class);
        String schema = "";
        String tableName = this.entityClass.getSimpleName();
        if (tableAnno != null) {
            schema = tableAnno.schema();
            tableName = tableAnno.name();
        } else {
            String javaBeanName = this.entityClass.getSimpleName();
            if (this.config.isCamel2underline()) {
                tableName = FieldUtil.camelToUnderline(javaBeanName);
            }
        }
        tableDefinition.setSchema(schema);
        tableDefinition.setTableName(tableName);
        tableDefinition.setColumnDefinitions(this.columnSelector.getColumnDefinitions());
        return tableDefinition;
    }
}

