/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.oschina.durcframework.easymybatis.ext.code.generator.ColumnDefinition;

public class TableDefinition {
    private String schema;
    private String tableName;
    private String comment;
    private List<ColumnDefinition> columnDefinitions = Collections.emptyList();

    public TableDefinition() {
    }

    public TableDefinition(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnDefinition> getTableColumns() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        ArrayList<ColumnDefinition> ret = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition columnDefinition : columns) {
            if (columnDefinition.isTransient()) continue;
            ret.add(columnDefinition);
        }
        return ret;
    }

    public List<ColumnDefinition> getAllColumns() {
        return this.getColumnDefinitions();
    }

    public boolean getHasDateField() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        for (ColumnDefinition definition : columns) {
            if (!"Date".equals(definition.getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasBigDecimalField() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        for (ColumnDefinition definition : columns) {
            if (!"BigDecimal".equals(definition.getJavaType())) continue;
            return true;
        }
        return false;
    }

    public ColumnDefinition getPkColumn() {
        for (ColumnDefinition column : this.columnDefinitions) {
            if (!column.getIsPk()) continue;
            return column;
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

