/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.generator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import net.oschina.durcframework.easymybatis.EasymybatisConfig;
import net.oschina.durcframework.easymybatis.ext.code.generator.ColumnDefinition;
import net.oschina.durcframework.easymybatis.ext.code.util.FieldUtil;
import net.oschina.durcframework.easymybatis.ext.code.util.ReflectionUtils;
import net.oschina.durcframework.easymybatis.handler.BaseEnum;
import net.oschina.durcframework.easymybatis.handler.EnumTypeHandler;
import net.oschina.durcframework.easymybatis.handler.FillHandler;
import net.oschina.durcframework.easymybatis.handler.FillType;
import org.springframework.util.StringUtils;

public class ColumnSelector {
    private static String GENERATOR_UUID = "system-uuid";
    private static String STRING_TYPE = "String";
    private Class<?> entityClass;
    private EasymybatisConfig config;

    public ColumnSelector(Class<?> entityClass, EasymybatisConfig config) {
        this.entityClass = entityClass;
        this.config = config;
    }

    private String getColumnType(Field field) {
        return field.getType().getSimpleName();
    }

    private String getColumnFullType(Field field) {
        return field.getType().getName();
    }

    private boolean isEnum(Field field) {
        Class<?> enumType = field.getType();
        boolean isEnum = enumType.isEnum();
        if (isEnum) {
            this.checkEnumn(enumType);
        }
        return isEnum;
    }

    private void checkEnumn(Class<?> enumType) {
        Class<?>[] arr;
        boolean isBaseEnum = false;
        Class<BaseEnum> baseEnumClass = BaseEnum.class;
        for (Class<?> type : arr = enumType.getInterfaces()) {
            if (!type.equals(baseEnumClass)) continue;
            isBaseEnum = true;
            break;
        }
        if (!isBaseEnum) {
            throw new RuntimeException("\u679a\u4e3e\u7c7b\uff1a" + enumType.getName() + "\u5fc5\u987b\u5b9e\u73b0" + baseEnumClass.getName() + "\u63a5\u53e3");
        }
    }

    private String getColumnName(Field field) {
        Column columnAnno = field.getAnnotation(Column.class);
        if (columnAnno != null) {
            String columnName = columnAnno.name();
            if (StringUtils.isEmpty((Object)columnName)) {
                throw new IllegalArgumentException(field.getName() + "\u6ce8\u89e3@Column(name=\"\")name\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return columnName;
        }
        String javaFieldName = field.getName();
        if (this.config.isCamel2underline()) {
            return FieldUtil.camelToUnderline(javaFieldName);
        }
        return javaFieldName;
    }

    private boolean isPK(Field field) {
        return field.getAnnotation(Id.class) != null;
    }

    private boolean isIdentity(GeneratedValue generatedValue) {
        return generatedValue != null && generatedValue.strategy() == GenerationType.IDENTITY;
    }

    private boolean isUuid(Field field, GeneratedValue generatedValue) {
        if (generatedValue == null) {
            return false;
        }
        String generator = generatedValue.generator();
        boolean isUuid = GENERATOR_UUID.equals(generator);
        String columnType = this.getColumnType(field);
        boolean isStringType = STRING_TYPE.equals(columnType);
        if (isUuid && !isStringType) {
            String columnName = this.getColumnName(field);
            throw new RuntimeException("\u5b57\u6bb5[" + columnName + "]\u5b9a\u4e49\u4e86UUID\u7b56\u7565\uff0c\u4f46\u7c7b\u578b\u4e0d\u662fString\uff0c\u5b9e\u9645\u7c7b\u578b\u4e3a\uff1a" + columnType);
        }
        return isUuid && isStringType;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        ArrayList<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>();
        List<Field> fields = ReflectionUtils.getDeclaredFields(this.entityClass);
        for (Field field : fields) {
            columnDefinitionList.add(this.buildColumnDefinition(field));
        }
        return columnDefinitionList;
    }

    protected ColumnDefinition buildColumnDefinition(Field field) {
        boolean isPk;
        ColumnDefinition columnDefinition = new ColumnDefinition();
        Transient transientAnno = field.getAnnotation(Transient.class);
        columnDefinition.setTransient(transientAnno != null);
        String columnName = this.getColumnName(field);
        String columnType = this.getColumnType(field);
        String fullType = this.getColumnFullType(field);
        boolean isEnum = this.isEnum(field);
        columnDefinition.setJavaFieldName(field.getName());
        columnDefinition.setColumnName(columnName);
        columnDefinition.setType(columnType);
        columnDefinition.setFullType(fullType);
        columnDefinition.setEnum(isEnum);
        if (isEnum) {
            columnDefinition.setTypeHandler(EnumTypeHandler.class.getName());
            columnDefinition.setFillType(FillType.UPDATE);
        }
        if (isPk = this.isPK(field)) {
            columnDefinition.setIsPk(isPk);
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (this.isIdentity(generatedValue)) {
                columnDefinition.setIsIdentity(true);
            } else if (this.isUuid(field, generatedValue)) {
                columnDefinition.setIsUuid(true);
            }
        }
        this.bindFill(columnDefinition);
        return columnDefinition;
    }

    private void bindFill(ColumnDefinition columnDefinition) {
        boolean canFill;
        String columnName = columnDefinition.getColumnName();
        FillHandler<?> fill = this.config.getFill(columnName);
        if (fill != null && (canFill = fill.canFill(this.entityClass, columnName))) {
            columnDefinition.setTypeHandler(((Object)fill).getClass().getName());
            columnDefinition.setFillType(fill.getFillType());
        }
    }
}

