/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.generator;

import net.oschina.durcframework.easymybatis.ext.code.util.FieldUtil;
import net.oschina.durcframework.easymybatis.ext.code.util.SqlTypeUtil;
import net.oschina.durcframework.easymybatis.handler.FillType;

public class ColumnDefinition {
    private static final String PREFIX = "entity.";
    private String javaFieldName;
    private String columnName;
    private String type;
    private String fullType;
    private boolean isTransient = false;
    private boolean isIdentity;
    private Boolean isUuid;
    private boolean isPk;
    private boolean isEnum;
    private String comment;
    private String typeHandler;
    private FillType fillType;

    public String getJdbcTypeProperty() {
        return this.typeHandler == null ? "jdbcType=\"" + this.getMybatisJdbcType() + "\"" : "";
    }

    public String getJavaTypeProperty() {
        return this.typeHandler != null ? "javaType=\"" + this.getFullType() + "\"" : "";
    }

    public String getTypeHandlerProperty() {
        return this.typeHandler != null ? " typeHandler=\"" + this.typeHandler + "\" " : "";
    }

    private String getTypeHandlerValue(FillType type) {
        return this.hasTypeHandler(type) ? ", typeHandler=" + this.typeHandler : "";
    }

    private boolean hasTypeHandler(FillType type) {
        return this.typeHandler != null && FillType.checkPower(this.fillType, type);
    }

    public String getMybatisInsertValue() {
        return this.getMybatisValue(FillType.INSERT);
    }

    public String getMybatisInsertValuePrefix() {
        return this.getMybatisValue(FillType.INSERT, PREFIX);
    }

    public String getMybatisUpdateValue() {
        return this.getMybatisValue(FillType.UPDATE);
    }

    public String getMybatisUpdateValuePrefix() {
        return this.getMybatisValue(FillType.UPDATE, PREFIX);
    }

    public String getMybatisSelectValue() {
        return this.getMybatisValue(FillType.SELECT);
    }

    private String getMybatisValue(FillType fillType) {
        return this.getMybatisValue(fillType, "");
    }

    private String getMybatisValue(FillType fillType, String prefix) {
        StringBuilder mybatisValue = new StringBuilder();
        mybatisValue.append("#{" + prefix + this.getJavaFieldName()).append(this.getTypeHandlerValue(fillType)).append("}");
        return mybatisValue.toString();
    }

    public boolean getIsIdentityPk() {
        return this.isPk && this.isIdentity;
    }

    public String getJavaFieldNameUF() {
        return FieldUtil.upperFirstLetter(this.getJavaFieldName());
    }

    public String getJavaFieldName() {
        return this.javaFieldName;
    }

    public String getJavaType() {
        return this.type;
    }

    public String getJavaTypeBox() {
        return SqlTypeUtil.convertToJavaBoxType(this.type);
    }

    public String getMybatisJdbcType() {
        return SqlTypeUtil.convertToMyBatisJdbcType(this.type);
    }

    public void setJavaFieldName(String javaFieldName) {
        this.javaFieldName = javaFieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getIsIdentity() {
        return this.isIdentity;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean getIsPk() {
        return this.isPk;
    }

    public void setIsPk(boolean isPk) {
        this.isPk = isPk;
    }

    public Boolean getIsUuid() {
        return this.isUuid;
    }

    public void setIsUuid(Boolean isUuid) {
        this.isUuid = isUuid;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean getIsEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public String getFullType() {
        return this.fullType;
    }

    public void setFullType(String fullType) {
        this.fullType = fullType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
    }

    public void setTypeHandler(String typeHandler) {
        this.typeHandler = typeHandler;
    }
}

