/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.oschina.durcframework.easymybatis.ext.code.client.ClientParam;
import net.oschina.durcframework.easymybatis.ext.code.generator.SQLContext;
import net.oschina.durcframework.easymybatis.ext.code.generator.TableDefinition;
import net.oschina.durcframework.easymybatis.ext.code.generator.TableSelector;
import net.oschina.durcframework.easymybatis.ext.code.util.VelocityUtil;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ClassPathResource;

public class Generator {
    public String generateCode(ClientParam clientParam) throws FileNotFoundException {
        InputStream templateInputStream = this.buildTemplateInputStream(clientParam.getTemplateClasspath());
        SQLContext sqlContext = this.buildClientSQLContextList(clientParam);
        String content = this.doGenerator(sqlContext, templateInputStream);
        return content;
    }

    private InputStream buildTemplateInputStream(String templateClasspath) throws FileNotFoundException {
        ClassPathResource resource = new ClassPathResource(templateClasspath);
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private SQLContext buildClientSQLContextList(ClientParam clientParam) {
        Class<?> entityClass = clientParam.getEntityClass();
        TableSelector tableSelector = new TableSelector(entityClass, clientParam.getConfig());
        TableDefinition tableDefinition = tableSelector.getTableDefinition();
        SQLContext context = new SQLContext(tableDefinition);
        String namespace = this.buildNamespace(clientParam.getMapperClass());
        context.setClassName(entityClass.getName());
        context.setClassSimpleName(entityClass.getSimpleName());
        context.setPackageName(entityClass.getPackage().getName());
        context.setNamespace(namespace);
        return context;
    }

    private String buildNamespace(Class<?> mapperClass) {
        return mapperClass.getName();
    }

    private String doGenerator(SQLContext sqlContext, InputStream inputStream) {
        VelocityContext context = new VelocityContext();
        TableDefinition tableDefinition = sqlContext.getTableDefinition();
        context.put("context", (Object)sqlContext);
        context.put("table", (Object)tableDefinition);
        context.put("pk", (Object)tableDefinition.getPkColumn());
        context.put("columns", tableDefinition.getTableColumns());
        context.put("allColumns", tableDefinition.getAllColumns());
        return VelocityUtil.generate(context, inputStream);
    }
}

