/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext.code.client;

import java.io.FileNotFoundException;
import net.oschina.durcframework.easymybatis.EasymybatisConfig;
import net.oschina.durcframework.easymybatis.ext.code.client.ClientParam;
import net.oschina.durcframework.easymybatis.ext.code.client.Generator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ClassClient {
    private static Log logger = LogFactory.getLog(ClassClient.class);
    private Generator generator = new Generator();
    private EasymybatisConfig config;

    public ClassClient(EasymybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config\u4e0d\u80fd\u4e3anull");
        }
        this.config = config;
    }

    public String genMybatisXml(Class<?> mapperClass, String templateClasspath) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u751f\u6210" + mapperClass.getName() + "\u5bf9\u5e94\u7684Mapper");
        }
        ClientParam param = new ClientParam();
        param.setTemplateClasspath(templateClasspath);
        param.setMapperClass(mapperClass);
        param.setConfig(this.config);
        try {
            return this.generator.generateCode(param);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

