/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.ext;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.oschina.durcframework.easymybatis.EasymybatisConfig;
import net.oschina.durcframework.easymybatis.dao.Dao;
import net.oschina.durcframework.easymybatis.ext.ClassScanner;
import net.oschina.durcframework.easymybatis.ext.code.client.ClassClient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class MapperLocationsBuilder {
    private static Log LOGGER = LogFactory.getLog(MapperLocationsBuilder.class);
    private static final String ENCODE = "UTF-8";
    private static final String XML_SUFFIX = ".xml";
    private static final String MAPPER_START = "<mapper>";
    private static final String MAPPER_END = "</mapper>";
    private static final String TEMPLATE_SUFFIX = ".vm";
    private static String DEFAULT_CLASS_PATH = "/easymybatis/tpl/";
    private Map<String, MapperResourceDefinition> mapperResourceStore = new HashMap<String, MapperResourceDefinition>();
    private EasymybatisConfig config = new EasymybatisConfig();
    private Attribute NAMESPACE;
    private String dbName;

    public Resource[] build(String basePackage) {
        this.init();
        try {
            Resource[] mapperLocations;
            String[] basePackages = StringUtils.tokenizeToStringArray((String)basePackage, (String)",; \t\n");
            ClassScanner classScanner = new ClassScanner(basePackages, Dao.class);
            Set<Class<?>> clazzsSet = classScanner.getClassSet();
            Resource[] resourceArray = mapperLocations = this.buildMapperLocations(clazzsSet);
            return resourceArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.distroy();
        }
    }

    private void init() {
        this.NAMESPACE = new DOMAttribute(new QName("namespace"));
    }

    private void distroy() {
        this.NAMESPACE = null;
        this.mapperResourceStore.clear();
    }

    public void storeMapperFile(Resource[] mapperLocations) {
        for (Resource mapperLocation : mapperLocations) {
            String filename = mapperLocation.getFilename();
            this.mapperResourceStore.put(filename, new MapperResourceDefinition(mapperLocation));
        }
    }

    private MapperResourceDefinition getMapperFile(String mapperFileName) {
        return this.mapperResourceStore.get(mapperFileName);
    }

    private Resource[] buildMapperLocations(Set<Class<?>> clazzsSet) {
        List<Resource> mapperLocations = this.buildMapperResource(clazzsSet);
        this.addUnmergedResource(mapperLocations);
        this.addCommonSqlClasspathMapper(mapperLocations);
        return mapperLocations.toArray(new Resource[mapperLocations.size()]);
    }

    private List<Resource> buildMapperResource(Set<Class<?>> clazzsSet) {
        final String templateClasspath = this.buildTemplateClasspath(this.getDbName());
        final ClassClient codeClient = new ClassClient(this.config);
        final List<Resource> mapperLocations = Collections.synchronizedList(new ArrayList(clazzsSet.size()));
        int poolSize = this.config.getMapperExecutorPoolSize();
        ExecutorService executorPool = Executors.newFixedThreadPool(poolSize > clazzsSet.size() ? clazzsSet.size() : poolSize);
        long startTime = System.currentTimeMillis();
        Iterator<Class<?>> i$ = clazzsSet.iterator();
        while (i$.hasNext()) {
            Class<?> mapperClass;
            final Class<?> daoClass = mapperClass = i$.next();
            executorPool.execute(new Runnable(){

                @Override
                public void run() {
                    String xml = codeClient.genMybatisXml(daoClass, templateClasspath);
                    xml = MapperLocationsBuilder.this.mergeExtMapperFile(daoClass, xml);
                    try {
                        MapperResource resource = new MapperResource(xml, daoClass);
                        mapperLocations.add(resource);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        try {
            executorPool.shutdown();
            executorPool.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)("\u751f\u6210Mapper\u5185\u5bb9\u603b\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2"));
            this.saveMapper(this.config.getMapperSaveDir(), mapperLocations);
            return mapperLocations;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void saveMapper(String saveDir, List<Resource> mapperLocations) {
        if (StringUtils.hasText((String)saveDir)) {
            try {
                LOGGER.info((Object)("\u4fdd\u5b58mapper\u6587\u4ef6\u5230" + saveDir));
                for (Resource resource : mapperLocations) {
                    FileOutputStream out = new FileOutputStream(saveDir + "/" + resource.getFilename());
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private String buildTemplateClasspath(String dbName) {
        String templateClasspath = this.config.getTemplateClasspath();
        if (templateClasspath != null) {
            return templateClasspath;
        }
        return DEFAULT_CLASS_PATH + this.buildTemplateFileName(dbName);
    }

    private String buildTemplateFileName(String dbName) {
        dbName = dbName.replaceAll("\\s", "").toLowerCase();
        return dbName + TEMPLATE_SUFFIX;
    }

    private void addCommonSqlClasspathMapper(List<Resource> mapperLocations) {
        String commonSqlClasspath = this.config.getCommonSqlClasspath();
        ClassPathResource res = new ClassPathResource(commonSqlClasspath);
        mapperLocations.add((Resource)res);
    }

    private void addUnmergedResource(List<Resource> mapperLocations) {
        Collection<MapperResourceDefinition> mapperResourceDefinitions = this.mapperResourceStore.values();
        for (MapperResourceDefinition mapperResourceDefinition : mapperResourceDefinitions) {
            if (mapperResourceDefinition.isMerged()) continue;
            LOGGER.info((Object)("\u52a0\u8f7d\u672a\u5408\u5e76Mapper\uff1a" + mapperResourceDefinition.getFilename()));
            mapperLocations.add(mapperResourceDefinition.getResource());
        }
    }

    private String mergeExtMapperFile(Class<?> mapperClass, String xml) {
        String mapperFileName = mapperClass.getSimpleName() + XML_SUFFIX;
        MapperResourceDefinition mapperResourceDefinition = this.getMapperFile(mapperFileName);
        if (mapperResourceDefinition == null) {
            return xml;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(xml.replace(MAPPER_END, ""));
        String extFileContent = this.getExtFileContent(mapperResourceDefinition.getResource());
        sb.append(extFileContent).append(MAPPER_END);
        mapperResourceDefinition.setMerged(true);
        return sb.toString();
    }

    private String getExtFileContent(Resource mapperLocation) {
        try {
            InputStream in = mapperLocation.getInputStream();
            Document document = this.buildSAXReader().read(in);
            Element mapperNode = document.getRootElement();
            String rootNodeName = mapperNode.getName();
            if (!"mapper".equals(rootNodeName)) {
                throw new Exception("mapper\u6587\u4ef6\u5fc5\u987b\u542b\u6709<mapper>\u8282\u70b9,\u662f\u5426\u7f3a\u5c11<mapper></mapper>?");
            }
            mapperNode.remove(this.NAMESPACE);
            String rootXml = mapperNode.asXML();
            rootXml = rootXml.replace(MAPPER_START, "").replace(MAPPER_END, "");
            return rootXml;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u52a0\u8f7d\u8d44\u6e90\u6587\u4ef6\u51fa\u9519,[" + mapperLocation.getFilename() + "]," + e.getMessage());
        }
    }

    private SAXReader buildSAXReader() {
        SAXReader reader = new SAXReader();
        reader.setEncoding(ENCODE);
        return reader;
    }

    public void setConfig(EasymybatisConfig config) {
        this.config = config;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setMapperExecutorPoolSize(int poolSize) {
        this.config.setMapperExecutorPoolSize(poolSize);
    }

    private static class MapperResource
    extends ByteArrayResource {
        private Class<?> mapperClass;

        public MapperResource(String xml, Class<?> mapperClass) throws UnsupportedEncodingException {
            super(xml.getBytes(MapperLocationsBuilder.ENCODE), mapperClass.getName());
            this.mapperClass = mapperClass;
        }

        public String getFilename() {
            return this.mapperClass.getSimpleName() + MapperLocationsBuilder.XML_SUFFIX;
        }
    }

    private static class MapperResourceDefinition {
        private boolean merged;
        private Resource resource;

        public MapperResourceDefinition(Resource resource) {
            this.resource = resource;
        }

        public String getFilename() {
            return this.resource.getFilename();
        }

        public boolean isMerged() {
            return this.merged;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

