/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis.dao.ext;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import net.oschina.durcframework.easymybatis.dao.ext.BaseDao;
import net.oschina.durcframework.easymybatis.ext.code.util.ReflectionUtils;
import net.oschina.durcframework.easymybatis.query.Query;
import net.oschina.durcframework.easymybatis.query.Queryable;
import net.oschina.durcframework.easymybatis.query.expression.ValueExpression;
import org.springframework.util.StringUtils;

public abstract class SchDao<Entity>
extends BaseDao<Entity>
implements net.oschina.durcframework.easymybatis.dao.SchDao<Entity> {
    private String pkName = this.buildPkName();
    private Class<?> entityClass;

    protected String getPkName() {
        return this.pkName;
    }

    private String buildPkName() {
        List<Field> fields = ReflectionUtils.getDeclaredFields(this.getEntityClass());
        for (Field field : fields) {
            if (!SchDao.isPK(field)) continue;
            return SchDao.getColumnName(field);
        }
        throw new RuntimeException(this.entityClass.getName() + "\u672a\u627e\u5230\u4e3b\u952e\uff0c\u662f\u5426\u540c\u65f6\u8bbe\u7f6e\u4e86@Id,@Column\u6ce8\u89e3");
    }

    private static String getColumnName(Field field) {
        Column columnAnno = field.getAnnotation(Column.class);
        if (columnAnno != null) {
            String columnName = columnAnno.name();
            if (StringUtils.isEmpty((Object)columnName)) {
                throw new IllegalArgumentException(field.getName() + "\u6ce8\u89e3@Column(name=\"\")name\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return columnName;
        }
        String javaFieldName = field.getName();
        return javaFieldName;
    }

    private static boolean isPK(Field field) {
        return field.getAnnotation(Id.class) != null;
    }

    @Override
    public Entity get(Object id) {
        return this.getByProperty(this.getPkName(), id);
    }

    @Override
    public Entity getByExpression(Queryable queryable) {
        return (Entity)this.getSqlSessionTemplate().selectOne(this.getStatement("getByExpression"), (Object)queryable);
    }

    @Override
    public Entity getByProperty(String column, Object value) {
        Query query = new Query();
        query.eq(column, value);
        return this.getByExpression(query);
    }

    @Override
    public List<Entity> listByProperty(String column, Object value) {
        Query query = new Query();
        query.eq(column, value);
        return this.find(query);
    }

    @Override
    public List<Entity> listByProperty(String column, Object value, Queryable queryable) {
        queryable.addExpression(new ValueExpression(column, value));
        return this.find(queryable);
    }

    @Override
    public List<Entity> find(Queryable queryable) {
        return this.getSqlSessionTemplate().selectList(this.getStatement("find"), (Object)queryable);
    }

    @Override
    public long countTotal(Queryable queryable) {
        Long total = (Long)this.getSqlSessionTemplate().selectOne(this.getStatement("countTotal"), (Object)queryable);
        return total == null ? 0L : total;
    }

    @Override
    public List<Map<String, Object>> findProjection(Queryable queryable) {
        return this.getSqlSessionTemplate().selectList(this.getStatement("findProjection"), (Object)queryable);
    }
}

