/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oschina.durcframework.easymybatis.EntityProcessor;
import net.oschina.durcframework.easymybatis.PageResult;
import net.oschina.durcframework.easymybatis.util.EntityUtils;

public class PageSupport<Entity>
implements PageResult<Entity> {
    private List<Entity> list;
    private long total = 0L;
    private int start = 0;
    private int pageIndex = 1;
    private int pageSize = 10;
    private int pageCount = 0;

    public PageResult process(EntityProcessor<Entity> processor) {
        if (processor == null) {
            return this;
        }
        PageSupport pageResult = this;
        if (processor != null) {
            List<Object> jsonObjList = PageSupport.processEntityToJSONObject(this.list, processor);
            pageResult.setList(jsonObjList);
        }
        return pageResult;
    }

    public static <Entity> List<Object> processEntityToJSONObject(List<Entity> list, EntityProcessor<Entity> processor) {
        ArrayList<Object> jsonObjList = new ArrayList<Object>(list.size());
        for (Entity entity : list) {
            Map<String, Object> jsonObject = EntityUtils.convertObj2Map(entity);
            processor.process(entity, jsonObject);
            jsonObjList.add(jsonObject);
        }
        return jsonObjList;
    }

    public int fatchCurrentPageIndex() {
        return this.pageIndex;
    }

    public int fatchPrePageIndex() {
        return this.pageIndex - 1 <= 0 ? 1 : this.pageIndex - 1;
    }

    public int fatchNextPageIndex() {
        return this.pageIndex + 1 > this.pageCount ? this.pageCount : this.pageIndex + 1;
    }

    public int fatchFirstPageIndex() {
        return 1;
    }

    public int fatchLastPageIndex() {
        return this.pageCount;
    }

    public List<Entity> fatchList() {
        return this.list;
    }

    public long fatchTotal() {
        return this.total;
    }

    public int fatchPageIndex() {
        return this.pageIndex;
    }

    public int fatchPageSize() {
        return this.pageSize;
    }

    public int fatchStart() {
        return this.start;
    }

    public int fatchPageCount() {
        return this.pageCount;
    }

    @Override
    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setList(List<Entity> list) {
        this.list = list;
    }
}

