/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.durcframework.easymybatis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.oschina.durcframework.easymybatis.handler.FillHandler;

public class EasymybatisConfig {
    private static final String COMMON_SQL_CLASSPATH = "easymybatis/commonSql.xml";
    private boolean camel2underline = Boolean.TRUE;
    private int mapperExecutorPoolSize = 20;
    private String templateClasspath;
    private String commonSqlClasspath = "easymybatis/commonSql.xml";
    private String mapperSaveDir;
    private List<FillHandler<?>> fillList = new ArrayList(8);

    public void setCamel2underline(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public boolean isCamel2underline() {
        return this.camel2underline;
    }

    public int getMapperExecutorPoolSize() {
        return this.mapperExecutorPoolSize;
    }

    public void setMapperExecutorPoolSize(int mapperExecutorPoolSize) {
        this.mapperExecutorPoolSize = mapperExecutorPoolSize;
    }

    public String getTemplateClasspath() {
        return this.templateClasspath;
    }

    public void setTemplateClasspath(String templateClasspath) {
        this.templateClasspath = templateClasspath;
    }

    public String getCommonSqlClasspath() {
        return this.commonSqlClasspath;
    }

    public void setCommonSqlClasspath(String commonSqlClasspath) {
        this.commonSqlClasspath = commonSqlClasspath;
    }

    public String getMapperSaveDir() {
        return this.mapperSaveDir;
    }

    public void setMapperSaveDir(String mapperSaveDir) {
        File dir = new File(mapperSaveDir);
        boolean selfMake = false;
        if (!dir.exists()) {
            dir.mkdirs();
            selfMake = true;
        }
        if (!dir.isDirectory()) {
            if (selfMake) {
                dir.delete();
            }
            throw new IllegalArgumentException("mapperSaveDir\u5fc5\u987b\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\u8def\u5f84\uff0cmapperSaveDir\uff1a" + mapperSaveDir);
        }
        this.mapperSaveDir = mapperSaveDir;
    }

    public <T extends FillHandler<?>> void setFills(List<T> fills) {
        for (FillHandler fill : fills) {
            this.fillList.add(fill);
        }
        Collections.sort(this.fillList, new Comparator<FillHandler<?>>(){

            @Override
            public int compare(FillHandler<?> o1, FillHandler<?> o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
    }

    public FillHandler<?> getFill(String columnName) {
        for (FillHandler<?> fillHandler : this.fillList) {
            if (!fillHandler.match(columnName)) continue;
            return fillHandler;
        }
        return null;
    }
}

